/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content.blocks;

import com.mojang.serialization.MapCodec;
import corundum.rubinated_nether.content.RNBlockStateProperties;
import corundum.rubinated_nether.content.RNBlocks;
import corundum.rubinated_nether.content.RNTags;
import corundum.rubinated_nether.content.blocks.entities.RunestoneBlockEntity;
import corundum.rubinated_nether.content.items.Rubination;
import corundum.rubinated_nether.content.items.RuneItem;
import corundum.rubinated_nether.mixin.accessors.DoublePlantBlockAccessor;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RunestoneBlock
extends BaseEntityBlock {
    private final MapCodec<? extends BaseEntityBlock> codec = RunestoneBlock.simpleCodec(RunestoneBlock::new);
    public static final EnumProperty<Rubination> HAS_RUNE = RNBlockStateProperties.HAS_RUNE;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    protected static final VoxelShape SHAPE_TOP = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape SHAPE_BOTTOM = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), (VoxelShape)Block.box((double)1.0, (double)10.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0));

    public RunestoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue(HAS_RUNE, (Comparable)((Object)Rubination.EMPTY)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.codec;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF});
        builder.add(new Property[]{HAS_RUNE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER ? SHAPE_BOTTOM : SHAPE_TOP;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.getValue(HALF);
        if (facing.getAxis() != Direction.Axis.Y || doubleblockhalf == DoubleBlockHalf.LOWER != (facing == Direction.UP)) {
            return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
        }
        return facingState.getBlock() instanceof RunestoneBlock && facingState.getValue(HALF) != doubleblockhalf ? (BlockState)facingState.setValue(HALF, (Comparable)doubleblockhalf) : Blocks.AIR.defaultBlockState();
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!(level.isClientSide || !player.isCreative() && player.hasCorrectToolForDrops(state, level, pos))) {
            DoublePlantBlockAccessor.invokePreventDropFromBottomPart(level, pos, state, player);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockPos = context.getClickedPos();
        Level level = context.getLevel();
        BlockPos abovePos = blockPos.above();
        BlockState aboveState = level.getBlockState(abovePos);
        if (blockPos.getY() < level.getMaxBuildHeight() - 1 && aboveState.canBeReplaced(context)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue(HAS_RUNE, (Comparable)((Object)Rubination.EMPTY));
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        level.setBlock(pos.above(), (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState blockstate = level.getBlockState(blockpos);
        return state.getValue(HALF) == DoubleBlockHalf.LOWER ? blockstate.isFaceSturdy((BlockGetter)level, blockpos, Direction.UP) : blockstate.is((Block)this);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (state.getValue(HAS_RUNE) == Rubination.EMPTY) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.getBlockEntity(this.getCorrectBlockPos(pos, state));
        if (blockEntity instanceof RunestoneBlockEntity) {
            RunestoneBlockEntity runestoneBlockEntity = (RunestoneBlockEntity)blockEntity;
            runestoneBlockEntity.popOutTheItem();
            this.handleSyncRuneValue(level, pos, Rubination.EMPTY);
            level.playLocalSound((Entity)player, SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (state.getValue(HAS_RUNE) != Rubination.EMPTY) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack itemstack = player.getItemInHand(hand);
        ItemInteractionResult iteminteractionresult = this.tryInsertIntoRunestone(level, pos, itemstack, player);
        return !iteminteractionresult.consumesAction() ? ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION : iteminteractionresult;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.is(newState.getBlock())) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RunestoneBlockEntity) {
            RunestoneBlockEntity runestoneBlockEntity = (RunestoneBlockEntity)blockEntity;
            runestoneBlockEntity.popOutTheItem();
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new RunestoneBlockEntity(blockPos, blockState);
    }

    private BlockPos getCorrectBlockPos(BlockPos pos, BlockState state) {
        return state.getValue(HALF) == DoubleBlockHalf.UPPER ? pos.below() : pos;
    }

    private void handleSyncRuneValue(Level level, BlockPos pos, Rubination rubination) {
        BlockState state = level.getBlockState(pos);
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            level.setBlock(pos, (BlockState)((BlockState)state.setValue(HAS_RUNE, (Comparable)((Object)rubination))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER), 2);
            level.setBlock(pos.above(), (BlockState)((BlockState)state.setValue(HAS_RUNE, (Comparable)((Object)rubination))).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
        } else {
            level.setBlock(pos, (BlockState)((BlockState)state.setValue(HAS_RUNE, (Comparable)((Object)rubination))).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
            level.setBlock(pos.below(), (BlockState)((BlockState)state.setValue(HAS_RUNE, (Comparable)((Object)rubination))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER), 2);
        }
    }

    private ItemInteractionResult tryInsertIntoRunestone(Level level, BlockPos pos, ItemStack stack, Player player) {
        BlockState blockState = level.getBlockState(pos);
        if (!stack.is(RNTags.Items.RUNES) || !(stack.getItem() instanceof RuneItem)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!blockState.is(RNBlocks.RUNESTONE) || blockState.getValue(HAS_RUNE) != Rubination.EMPTY) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide) {
            this.setItemIntoRunestone(level, pos, blockState, player, stack);
        }
        level.playLocalSound((Entity)player, SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private void setItemIntoRunestone(Level level, BlockPos pos, BlockState blockState, Player player, ItemStack stack) {
        this.handleSyncRuneValue(level, pos, ((RuneItem)stack.getItem()).getRubination());
        BlockEntity blockEntity = level.getBlockEntity(this.getCorrectBlockPos(pos, blockState));
        if (!(blockEntity instanceof RunestoneBlockEntity)) {
            return;
        }
        ItemStack itemStack = stack.consumeAndReturn(1, (LivingEntity)player);
        ((RunestoneBlockEntity)blockEntity).setTheItem(itemStack);
        blockEntity.setChanged();
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockState));
    }
}

