/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content.blocks;

import com.mojang.serialization.MapCodec;
import corundum.rubinated_nether.content.RNBlockEntities;
import corundum.rubinated_nether.content.blocks.entities.RubyLaserBlockEntity;
import corundum.rubinated_nether.utils.BEBlock;
import corundum.rubinated_nether.utils.ShapeUtils;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RubyLaserBlock
extends DirectionalBlock
implements BEBlock<RubyLaserBlockEntity> {
    public static final MapCodec<RubyLaserBlock> CODEC = RubyLaserBlock.simpleCodec(RubyLaserBlock::new);
    public static final Map<Direction, VoxelShape> SHAPES = ShapeUtils.allDirections(Shapes.or((VoxelShape)RubyLaserBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), (VoxelShape)RubyLaserBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0)));
    public static final IntegerProperty POWER = IntegerProperty.create((String)"power", (int)0, (int)15);
    public static final BooleanProperty TINTED = BooleanProperty.create((String)"tinted");

    public RubyLaserBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue((Property)TINTED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWER, TINTED});
    }

    @Override
    public BlockEntityType<? extends RubyLaserBlockEntity> getBlockEntityType() {
        return (BlockEntityType)RNBlockEntities.RUBY_LASER.get();
    }

    @Override
    public Class<? extends RubyLaserBlockEntity> getBlockEntityClass() {
        return RubyLaserBlockEntity.class;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        boolean bl = (Boolean)state.getValue((Property)TINTED);
        level.playLocalSound(pos, SoundEvents.COMPARATOR_CLICK, SoundSource.BLOCKS, 0.5f, bl ? 0.55f : 0.5f, true);
        level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)TINTED));
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof RubyLaserBlockEntity)) {
            return;
        }
        RubyLaserBlockEntity laser = (RubyLaserBlockEntity)be;
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(laser.getPowerLevel())));
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockPos = pos.relative(direction.getOpposite());
        level.neighborChanged(blockPos, (Block)this, pos);
        level.updateNeighborsAtExceptFromFacing(blockPos, (Block)this, direction);
    }

    public int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.getSignal(state, level, pos, direction);
    }

    public int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return state.getValue((Property)FACING) == direction ? (Integer)state.getValue((Property)POWER) : 0;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }
}

