/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content.blocks;

import com.mojang.serialization.MapCodec;
import corundum.rubinated_nether.content.RNBlockEntities;
import corundum.rubinated_nether.content.RNBlockStateProperties;
import corundum.rubinated_nether.content.RNBlocks;
import corundum.rubinated_nether.content.RNParticleTypes;
import corundum.rubinated_nether.content.blocks.entities.RubinationAltarBlockEntity;
import corundum.rubinated_nether.content.blocks.entities.RunestoneBlockEntity;
import corundum.rubinated_nether.content.items.Rubination;
import corundum.rubinated_nether.content.menu.RubinationMenu;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RubinationAltarBlock
extends BaseEntityBlock {
    private final MapCodec<? extends BaseEntityBlock> codec = RubinationAltarBlock.simpleCodec(RubinationAltarBlock::new);
    protected static final VoxelShape SHAPE_BOTTOM = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    protected static final VoxelShape SHAPE_TOP = Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SHAPE = Shapes.or((VoxelShape)SHAPE_BOTTOM, (VoxelShape)SHAPE_TOP);
    public static final List<BlockPos> RUNESTONE_OFFSETS = BlockPos.betweenClosedStream((int)-3, (int)0, (int)-3, (int)3, (int)1, (int)3).filter(blockPos -> Math.abs(blockPos.getX()) > 1 || Math.abs(blockPos.getZ()) > 1).map(BlockPos::immutable).toList();

    public RubinationAltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.codec;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        for (BlockPos blockPos : RUNESTONE_OFFSETS) {
            if (random.nextInt(2) != 0) continue;
            BlockPos stonePos = pos.offset((Vec3i)blockPos);
            if (!RubinationAltarBlock.isValidCatalyst(level, pos, blockPos) || level.getBlockState(stonePos).getValue(RNBlockStateProperties.HAS_RUNE) == Rubination.EMPTY) continue;
            level.addParticle((ParticleOptions)RNParticleTypes.RUBINATE.get(), (double)pos.getX() + 0.5, (double)pos.getY() + 2.0, (double)pos.getZ() + 0.5, (double)((float)blockPos.getX() + random.nextFloat()) - 0.5, (double)((float)blockPos.getY() - random.nextFloat() - 0.5f), (double)((float)blockPos.getZ() + random.nextFloat()) - 0.5);
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RubinationAltarBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return RubinationAltarBlock.createTicker(level, blockEntityType, (BlockEntityType<? extends RubinationAltarBlockEntity>)((BlockEntityType)RNBlockEntities.RUBINATION_ALTAR.get()));
    }

    private static <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level level, BlockEntityType<T> serverType, BlockEntityType<? extends RubinationAltarBlockEntity> clientType) {
        return level.isClientSide ? RubinationAltarBlock.createTickerHelper(serverType, clientType, RubinationAltarBlockEntity::tick) : null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return this.use(state, level, pos, player);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return switch (this.use(state, level, pos, player)) {
            case InteractionResult.SUCCESS -> ItemInteractionResult.SUCCESS;
            case InteractionResult.CONSUME -> ItemInteractionResult.CONSUME;
            default -> ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        };
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu(state.getMenuProvider(level, pos));
        return InteractionResult.CONSUME;
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof RubinationAltarBlockEntity)) {
            return null;
        }
        RubinationAltarBlockEntity altarBlockEntity = (RubinationAltarBlockEntity)blockEntity;
        Component component = altarBlockEntity.getDisplayName();
        return new SimpleMenuProvider((i, inventory, player) -> new RubinationMenu(i, inventory, ContainerLevelAccess.create((Level)level, (BlockPos)pos)), component);
    }

    public boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return false;
    }

    public static boolean isValidCatalyst(Level level, BlockPos tablePos, BlockPos offsetPos) {
        return level.getBlockState(tablePos.offset((Vec3i)offsetPos)).is((Block)RNBlocks.RUNESTONE.get());
    }

    public static Item getRuneFromCatalyst(Level level, BlockPos tablePos, BlockPos offsetPos) {
        BlockEntity blockEntity = level.getBlockEntity(tablePos.offset((Vec3i)offsetPos));
        if (!(blockEntity instanceof RunestoneBlockEntity)) {
            return null;
        }
        RunestoneBlockEntity runestoneBlockEntity = (RunestoneBlockEntity)blockEntity;
        return runestoneBlockEntity.getTheItem().getItem();
    }
}

