/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content.blocks;

import com.mojang.serialization.MapCodec;
import corundum.rubinated_nether.content.RNBlockEntities;
import corundum.rubinated_nether.content.blocks.entities.AbstractFreezerBlockEntity;
import corundum.rubinated_nether.content.blocks.entities.FreezerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class FreezerBlock
extends AbstractFurnaceBlock {
    public static final MapCodec<FreezerBlock> CODEC = FreezerBlock.simpleCodec(FreezerBlock::new);

    public FreezerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    protected MapCodec<? extends AbstractFurnaceBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FreezerBlockEntity(pos, state);
    }

    protected void openContainer(Level level, BlockPos blockPos, Player player) {
        if (level.isClientSide()) {
            return;
        }
        BlockEntity entity = level.getBlockEntity(blockPos);
        if (entity instanceof FreezerBlockEntity) {
            FreezerBlockEntity freezer = (FreezerBlockEntity)entity;
            player.openMenu((MenuProvider)freezer);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            return;
        }
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 1.0 + (double)random.nextFloat() * 6.0 / 16.0;
        double z = (double)pos.getZ() + 0.5;
        level.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, x, y, z, 0.0, 0.0, 0.0);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return FreezerBlock.createTicker(level, blockEntityType, (BlockEntityType<? extends FreezerBlockEntity>)((BlockEntityType)RNBlockEntities.FREEZER.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level level, BlockEntityType<T> serverType, BlockEntityType<? extends FreezerBlockEntity> clientType) {
        return level.isClientSide() ? null : FreezerBlock.createTickerHelper(serverType, clientType, AbstractFreezerBlockEntity::serverTick);
    }
}

