/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content.blocks;

import corundum.rubinated_nether.content.RNTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DryIceBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public DryIceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        this.checkAndDrop(state, level, pos);
    }

    private void checkAndDrop(BlockState state, Level level, BlockPos pos) {
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, false);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (!(level instanceof Level)) {
            return false;
        }
        Level levelInstance = (Level)level;
        BlockState blockState = level.getBlockState(pos.below());
        if (levelInstance.dimension() == Level.NETHER) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                FluidState fluidState = level.getFluidState(pos.below().relative(direction));
                if (!fluidState.is(RNTags.Fluids.COLDEST_FLUID)) continue;
                return blockState.is(RNTags.Blocks.COLDEST_ICE);
            }
            return false;
        }
        ResourceKey aetherDimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"the_aether"));
        if (levelInstance.dimension() == Level.END || levelInstance.dimension() == aetherDimension) {
            return Block.isFaceFull((VoxelShape)blockState.getCollisionShape((BlockGetter)level, pos.below()), (Direction)Direction.UP);
        }
        return blockState.is(RNTags.Blocks.COLDEST_ICE);
    }
}

