/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content.blocks;

import corundum.rubinated_nether.utils.RNConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChandelierBlock
extends Block {
    protected static final VoxelShape SHAPE_BOTTOM = Block.box((double)2.0, (double)-2.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0);
    protected static final VoxelShape SHAPE_TOP = Block.box((double)-8.0, (double)5.0, (double)-8.0, (double)24.0, (double)10.0, (double)24.0);
    protected static final VoxelShape SHAPE = Shapes.or((VoxelShape)SHAPE_BOTTOM, (VoxelShape)SHAPE_TOP);

    public ChandelierBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        pLevel.scheduleTick(pCurrentPos, (Block)this, 2);
        return pState;
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!this.canSurvive(pState, (LevelReader)pLevel, pPos)) {
            ChandelierBlock.spawnFallingChandelier(pState, pLevel, pPos);
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos.above(), (Direction)Direction.UP);
    }

    private static void spawnFallingChandelier(BlockState pState, ServerLevel pLevel, BlockPos pPos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.mutable();
        BlockState blockstate = pLevel.getBlockState((BlockPos)blockpos$mutableblockpos);
        FallingBlockEntity fallingblockentity = FallingBlockEntity.fall((Level)pLevel, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate);
        int i = Math.max(1 + pPos.getY() - blockpos$mutableblockpos.getY(), 6);
        float f = RNConfig.chandelierMultiplier * (float)i;
        fallingblockentity.setHurtsEntities(f, RNConfig.chandelierMaxDamage);
    }
}

