/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class BronzeBulbBlock
extends Block {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public final BlockState nextStateWaxed;
    public final BlockState nextStateScraped;

    public BronzeBulbBlock(BlockBehaviour.Properties properties, Block block, Block block2) {
        super(properties);
        this.nextStateWaxed = block != null ? block.defaultBlockState() : null;
        this.nextStateScraped = block2 != null ? block2.defaultBlockState() : null;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (oldState.getBlock() != state.getBlock() && level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            this.checkAndFlip(state, serverlevel, pos);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            this.checkAndFlip(state, serverlevel, pos);
        }
    }

    public void checkAndFlip(BlockState state, ServerLevel level, BlockPos pos) {
        boolean flag = level.hasNeighborSignal(pos);
        if (flag != (Boolean)state.getValue((Property)POWERED)) {
            BlockState blockstate = state;
            if (!((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                blockstate = (BlockState)state.cycle((Property)LIT);
                level.playSound(null, pos, (Boolean)blockstate.getValue((Property)LIT) != false ? SoundEvents.AMETHYST_BLOCK_BREAK : SoundEvents.AMETHYST_BLOCK_PLACE, SoundSource.BLOCKS);
            }
            level.setBlock(pos, (BlockState)blockstate.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return (Boolean)level.getBlockState(pos).getValue((Property)LIT) != false ? 15 : 0;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (player.getAbilities().mayBuild) {
            if (player.getItemInHand(hand).is(Items.HONEYCOMB)) {
                this.setWaxed(player, state, (LevelAccessor)level, pos);
                if (!player.isCreative()) {
                    itemStack.shrink(1);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (player.getItemInHand(hand).is(ItemTags.AXES)) {
                this.setScraped(player, state, (LevelAccessor)level, pos);
                if (!player.isCreative()) {
                    itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        } else {
            return ItemInteractionResult.FAIL;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void setScraped(@Nullable Player player, BlockState state, LevelAccessor world, BlockPos pos) {
        if (this.nextStateScraped != null) {
            world.setBlock(pos, (BlockState)this.nextStateScraped.setValue((Property)LIT, (Comparable)((Boolean)state.getValue((Property)LIT))), 11);
            world.playSound((Player)null, pos, SoundEvents.ENDERMAN_DEATH, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
        }
    }

    public void setWaxed(@Nullable Player player, BlockState state, LevelAccessor world, BlockPos pos) {
        if (this.nextStateWaxed != null) {
            world.setBlock(pos, (BlockState)this.nextStateWaxed.setValue((Property)LIT, (Comparable)((Boolean)state.getValue((Property)LIT))), 11);
            world.playSound((Player)null, pos, SoundEvents.ENDERMAN_DEATH, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, POWERED});
    }
}

