/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content;

import corundum.rubinated_nether.content.RNItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.LootTableLoadEvent;

public class RNLootInjector {
    public static void init() {
        NeoForge.EVENT_BUS.register(RNLootInjector.class);
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation name = event.getName();
        switch (name.toString()) {
            case "minecraft:chests/end_city_treasure": {
                RNLootInjector.addRune(event, (Item)RNItems.GREED_RUNE.get(), 0.05f);
                RNLootInjector.addRune(event, (Item)RNItems.ENVY_RUNE.get(), 0.05f);
                break;
            }
            case "minecraft:chests/ancient_city": {
                RNLootInjector.addRune(event, (Item)RNItems.GLUTTONY_RUNE.get(), 0.05f);
                RNLootInjector.addRune(event, (Item)RNItems.WRATH_RUNE.get(), 0.05f);
                break;
            }
            case "minecraft:chests/buried_treasure": {
                RNLootInjector.addRune(event, (Item)RNItems.LUXURIA_RUNE.get(), 0.05f);
                RNLootInjector.addRune(event, (Item)RNItems.PRIDE_RUNE.get(), 0.05f);
                break;
            }
            case "minecraft:chests/stronghold_library": {
                RNLootInjector.addRune(event, (Item)RNItems.SUPERBIA_RUNE.get(), 0.05f);
                RNLootInjector.addRune(event, (Item)RNItems.ARDENTER_RUNE.get(), 0.05f);
                break;
            }
            case "minecraft:chests/nether_bridge": {
                RNLootInjector.addRune(event, (Item)RNItems.SLOTH_RUNE.get(), 0.05f);
                break;
            }
            case "minecraft:chests/bastion_treasure": {
                RNLootInjector.addRune(event, (Item)RNItems.VAINGLORY_RUNE.get(), 0.05f);
                break;
            }
            case "minecraft:chests/underwater_ruin_big": {
                RNLootInjector.addRune(event, (Item)RNItems.INSIDIAE_RUNE.get(), 0.05f);
                break;
            }
            case "minecraft:chests/woodland_mansion": {
                RNLootInjector.addRune(event, (Item)RNItems.STUDIOSE_RUNE.get(), 0.05f);
                break;
            }
            case "minecraft:chests/trial_chambers/reward_unique": {
                RNLootInjector.addRune(event, (Item)RNItems.NIMIS_RUNE.get(), 0.1f);
                RNLootInjector.addRune(event, (Item)RNItems.TRISTIA_RUNE.get(), 0.1f);
                RNLootInjector.addRune(event, (Item)RNItems.ACEDIA_RUNE.get(), 0.1f);
            }
        }
    }

    private static void addRune(LootTableLoadEvent event, Item item, float chance) {
        LootPool pool = LootPool.lootPool().add(LootItem.lootTableItem((ItemLike)item).when(LootItemRandomChanceCondition.randomChance((float)chance))).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).build();
        event.getTable().addPool(pool);
    }
}

