/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content;

import corundum.rubinated_nether.content.entity.BronzeEntity;
import corundum.rubinated_nether.content.entity.BronzeShotProjectileEntity;
import corundum.rubinated_nether.content.entity.client.BronzeModel;
import corundum.rubinated_nether.content.entity.client.BronzeRenderer;
import corundum.rubinated_nether.content.entity.layer.RNModelLayers;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(modid="rubinated_nether", bus=EventBusSubscriber.Bus.MOD)
public class RNEntityCreator {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"rubinated_nether");
    public static final Supplier<EntityType<BronzeShotProjectileEntity>> BRONZE_SHOT = RNEntityCreator.registerEntity("bronze_shot", EntityType.Builder.of(BronzeShotProjectileEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f));
    public static final Supplier<EntityType<BronzeEntity>> BRONZE = RNEntityCreator.registerEntity("bronze", EntityType.Builder.of(BronzeEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.7f, 1.4f));

    private static <T extends Entity> Supplier<EntityType<T>> registerEntity(String name, EntityType.Builder<T> builder) {
        return ENTITY_TYPES.register(name, () -> builder.build(name));
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put(BRONZE.get(), BronzeEntity.createAttributes().build());
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(BRONZE.get(), BronzeRenderer::new);
    }

    @SubscribeEvent
    public static void registerModelLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(RNModelLayers.BRONZE, BronzeModel::createBodyLayer);
    }
}

