/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content;

import corundum.rubinated_nether.content.RNItems;
import corundum.rubinated_nether.content.blocks.BrazierBlock;
import corundum.rubinated_nether.content.blocks.ChandelierBlock;
import corundum.rubinated_nether.content.blocks.DryIceBlock;
import corundum.rubinated_nether.content.blocks.FreezerBlock;
import corundum.rubinated_nether.content.blocks.LavaLampBlock;
import corundum.rubinated_nether.content.blocks.LavaSpongeBlock;
import corundum.rubinated_nether.content.blocks.MagmaExperienceBlock;
import corundum.rubinated_nether.content.blocks.RubinationAltarBlock;
import corundum.rubinated_nether.content.blocks.RubyLaserBlock;
import corundum.rubinated_nether.content.blocks.RunestoneBlock;
import corundum.rubinated_nether.content.blocks.SixWayPillarBlock;
import corundum.rubinated_nether.content.blocks.TarnishingBronze;
import corundum.rubinated_nether.content.blocks.TarnishingBronzeBlock;
import corundum.rubinated_nether.content.blocks.TarnishingBronzeBulbBlock;
import corundum.rubinated_nether.content.blocks.TarnishingBronzeSlabBlock;
import corundum.rubinated_nether.content.blocks.TarnishingBronzeStairBlock;
import corundum.rubinated_nether.content.blocks.TarnishingPillarBlock;
import corundum.rubinated_nether.content.items.WaxableBlockItem;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class RNBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"rubinated_nether");
    public static final DeferredBlock<Block> NETHER_RUBY_ORE = RNBlocks.registerBlockAndItem("nether_ruby_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)6), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHERRACK).strength(2.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> RUBINATED_BLACKSTONE = RNBlocks.registerBlockAndItem("rubinated_blackstone", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)0, (int)1), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GILDED_BLACKSTONE)));
    public static final DeferredBlock<Block> MOLTEN_RUBY_ORE = RNBlocks.registerBlockAndItem("molten_ruby_ore", () -> new MagmaExperienceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MAGMA_BLOCK).strength(2.0f).requiresCorrectToolForDrops(), (IntProvider)UniformInt.of((int)4, (int)8)));
    public static final DeferredBlock<Block> RUBY_BLOCK = RNBlocks.registerBlockAndItem("ruby_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIAMOND_BLOCK).mapColor(MapColor.FIRE)));
    public static final DeferredBlock<RotatedPillarBlock> MOLTEN_RUBY_BLOCK = RNBlocks.registerBlockAndItem("molten_ruby_block", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIAMOND_BLOCK)));
    public static final DeferredBlock<Block> BLEEDING_OBSIDIAN = RNBlocks.registerBlockAndItem("bleeding_obsidian", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRYING_OBSIDIAN)));
    public static final DeferredBlock<Block> RUBY_LANTERN = RNBlocks.registerBlockAndItem("ruby_lantern", () -> new LanternBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN)));
    public static final DeferredBlock<Block> CHANDELIER = RNBlocks.registerBlockAndItem("ruby_chandelier", () -> new ChandelierBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COPPER_BLOCK).noOcclusion().lightLevel($ -> 15)));
    public static final DeferredBlock<RotatedPillarBlock> LAVA_LAMP = RNBlocks.registerBlockAndItem("lava_lamp", () -> new LavaLampBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COPPER_BLOCK).lightLevel($ -> 15)));
    public static final DeferredBlock<Block> DRY_ICE = RNBlocks.registerBlockAndItem("dry_ice", () -> new DryIceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLUE_ICE).requiresCorrectToolForDrops().friction(0.995f)));
    public static final DeferredBlock<Block> SOAKSTONE = RNBlocks.registerBlockAndItem("soakstone", () -> new LavaSpongeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHERRACK)));
    public static final DeferredBlock<Block> RUBY_GLASS = RNBlocks.registerBlockAndItem("ruby_glass", () -> new StainedGlassBlock(DyeColor.RED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_STAINED_GLASS).explosionResistance(1000.0f).strength(5.0f, 6.0f).isViewBlocking(RNBlocks::never)));
    public static final DeferredBlock<IronBarsBlock> RUBY_GLASS_PANE = RNBlocks.registerBlockAndItem("ruby_glass_pane", () -> new StainedGlassPaneBlock(DyeColor.RED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)RUBY_GLASS.get()))));
    public static final DeferredBlock<Block> ORNATE_RUBY_GLASS = RNBlocks.registerBlockAndItem("ornate_ruby_glass", () -> new StainedGlassBlock(DyeColor.RED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)RUBY_GLASS.get()))));
    public static final DeferredBlock<IronBarsBlock> ORNATE_RUBY_GLASS_PANE = RNBlocks.registerBlockAndItem("ornate_ruby_glass_pane", () -> new StainedGlassPaneBlock(DyeColor.RED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)RUBY_GLASS.get()))));
    public static final DeferredBlock<Block> MOLTEN_RUBY_GLASS = RNBlocks.registerBlockAndItem("molten_ruby_glass", () -> new StainedGlassBlock(DyeColor.RED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)RUBY_GLASS.get())).lightLevel($ -> 10)));
    public static final DeferredBlock<IronBarsBlock> MOLTEN_RUBY_GLASS_PANE = RNBlocks.registerBlockAndItem("molten_ruby_glass_pane", () -> new StainedGlassPaneBlock(DyeColor.RED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)MOLTEN_RUBY_GLASS.get()))));
    public static final DeferredBlock<Block> RUNESTONE = RNBlocks.registerBlockAndItem("runestone", () -> new RunestoneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BASALT).lightLevel($ -> 2).noOcclusion()));
    public static final DeferredBlock<Block> SHRINE_STONE = RNBlocks.registerBlockAndItem("shrine_stone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE)));
    public static final DeferredBlock<Block> POLISHED_SHRINE_STONE = RNBlocks.registerBlockAndItem("polished_shrine_stone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHRINE_STONE.get()))));
    public static final DeferredBlock<SlabBlock> POLISHED_SHRINE_STONE_SLAB = RNBlocks.registerBlockAndItem("polished_shrine_stone_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)POLISHED_SHRINE_STONE.get()))));
    public static final DeferredBlock<StairBlock> POLISHED_SHRINE_STONE_STAIRS = RNBlocks.registerBlockAndItem("polished_shrine_stone_stairs", () -> new StairBlock(((Block)POLISHED_SHRINE_STONE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)POLISHED_SHRINE_STONE.get()))));
    public static final DeferredBlock<WallBlock> POLISHED_SHRINE_STONE_WALL = RNBlocks.registerBlockAndItem("polished_shrine_stone_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)POLISHED_SHRINE_STONE.get()))));
    public static final DeferredBlock<Block> SHRINE_STONE_TILES = RNBlocks.registerBlockAndItem("shrine_stone_tiles", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHRINE_STONE.get()))));
    public static final DeferredBlock<SlabBlock> SHRINE_STONE_TILES_SLAB = RNBlocks.registerBlockAndItem("shrine_stone_tiles_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHRINE_STONE_TILES.get()))));
    public static final DeferredBlock<StairBlock> SHRINE_STONE_TILES_STAIRS = RNBlocks.registerBlockAndItem("shrine_stone_tiles_stairs", () -> new StairBlock(((Block)SHRINE_STONE_TILES.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHRINE_STONE_TILES.get()))));
    public static final DeferredBlock<WallBlock> SHRINE_STONE_TILES_WALL = RNBlocks.registerBlockAndItem("shrine_stone_tiles_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHRINE_STONE_TILES.get()))));
    public static final DeferredBlock<RotatedPillarBlock> SHRINE_STONE_PILLAR = RNBlocks.registerBlockAndItem("shrine_stone_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHRINE_STONE.get()))));
    public static final DeferredBlock<Block> SHRINE_STONE_BRICKS = RNBlocks.registerBlockAndItem("shrine_stone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHRINE_STONE.get()))));
    public static final DeferredBlock<SlabBlock> SHRINE_STONE_BRICKS_SLAB = RNBlocks.registerBlockAndItem("shrine_stone_bricks_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHRINE_STONE_BRICKS.get()))));
    public static final DeferredBlock<StairBlock> SHRINE_STONE_BRICKS_STAIRS = RNBlocks.registerBlockAndItem("shrine_stone_bricks_stairs", () -> new StairBlock(((Block)SHRINE_STONE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHRINE_STONE_BRICKS.get()))));
    public static final DeferredBlock<WallBlock> SHRINE_STONE_BRICKS_WALL = RNBlocks.registerBlockAndItem("shrine_stone_bricks_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHRINE_STONE_BRICKS.get()))));
    public static final DeferredBlock<Block> CHISELED_SHRINE_STONE_BRICKS = RNBlocks.registerBlockAndItem("chiseled_shrine_stone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHRINE_STONE.get()))));
    public static final DeferredBlock<SixWayPillarBlock> RUBINATED_CHISELED_SHRINE_STONE_BRICKS = RNBlocks.registerBlockAndItem("rubinated_chiseled_shrine_stone_bricks", () -> new SixWayPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CHISELED_SHRINE_STONE_BRICKS.get())).lightLevel($ -> 7)));
    public static final DeferredBlock<Block> RUBINATED_SHRINE_STONE_BRICKS = RNBlocks.registerBlockAndItem("rubinated_shrine_stone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHRINE_STONE_BRICKS.get())).lightLevel($ -> 7)));
    public static final DeferredBlock<Block> FREEZER = RNBlocks.registerBlockAndItem("freezer", () -> new FreezerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COPPER_BLOCK).noOcclusion()));
    public static final DeferredBlock<Block> RUBY_LASER = RNBlocks.registerBlockAndItem("ruby_laser", () -> new RubyLaserBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COPPER_BLOCK).noOcclusion()));
    public static final DeferredBlock<Block> BRAZIER = RNBlocks.registerBlockAndItem("ruby_brazier", () -> new BrazierBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COPPER_BLOCK).mapColor(MapColor.FIRE).noOcclusion()));
    public static final DeferredBlock<Block> RUBINATION_ALTAR = RNBlocks.registerBlockAndItem("rubination_altar", () -> new RubinationAltarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OBSIDIAN).mapColor(MapColor.NETHER)));
    public static final DeferredBlock<Block> BRONZE_BLOCK = RNBlocks.registerWaxableBlock("bronze_block", () -> new TarnishingBronzeBlock(TarnishingBronze.TarnishState.UNAFFECTED, BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).requiresCorrectToolForDrops().strength(5.0f, 150.0f).sound(SoundType.COPPER).randomTicks()));
    public static final DeferredBlock<Block> DISCOLORED_BRONZE_BLOCK = RNBlocks.registerWaxableBlock("discolored_bronze_block", () -> new TarnishingBronzeBlock(TarnishingBronze.TarnishState.DISCOLORED, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_PINK).requiresCorrectToolForDrops().strength(15.0f, 300.0f).sound(SoundType.COPPER).randomTicks()));
    public static final DeferredBlock<Block> CORRODED_BRONZE_BLOCK = RNBlocks.registerWaxableBlock("corroded_bronze_block", () -> new TarnishingBronzeBlock(TarnishingBronze.TarnishState.CORRODED, BlockBehaviour.Properties.of().mapColor(MapColor.CRIMSON_STEM).requiresCorrectToolForDrops().strength(25.0f, 600.0f).sound(SoundType.COPPER).randomTicks()));
    public static final DeferredBlock<Block> TARNISHED_BRONZE_BLOCK = RNBlocks.registerWaxableBlock("tarnished_bronze_block", () -> new TarnishingBronzeBlock(TarnishingBronze.TarnishState.TARNISHED, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_BLACK).requiresCorrectToolForDrops().strength(50.0f, 1200.0f).sound(SoundType.COPPER).randomTicks()));
    public static final DeferredBlock<Block> CRYSTALLIZED_BRONZE_BLOCK = RNBlocks.registerWaxableBlock("crystallized_bronze_block", () -> new TarnishingBronzeBlock(TarnishingBronze.TarnishState.CRYSTALLIZED, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_WHITE).requiresCorrectToolForDrops().strength(1.0f, 6.0f).sound(SoundType.COPPER).randomTicks()));
    public static final DeferredBlock<Block> CUT_BRONZE_PILLAR = RNBlocks.registerWaxableBlock("cut_bronze_pillar", () -> new TarnishingPillarBlock(TarnishingBronze.TarnishState.UNAFFECTED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)BRONZE_BLOCK.get())).requiresCorrectToolForDrops().strength(5.0f, 150.0f)));
    public static final DeferredBlock<Block> DISCOLORED_CUT_BRONZE_PILLAR = RNBlocks.registerWaxableBlock("discolored_cut_bronze_pillar", () -> new TarnishingPillarBlock(TarnishingBronze.TarnishState.DISCOLORED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DISCOLORED_BRONZE_BLOCK.get())).requiresCorrectToolForDrops().strength(15.0f, 300.0f)));
    public static final DeferredBlock<Block> CORRODED_CUT_BRONZE_PILLAR = RNBlocks.registerWaxableBlock("corroded_cut_bronze_pillar", () -> new TarnishingPillarBlock(TarnishingBronze.TarnishState.CORRODED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CORRODED_BRONZE_BLOCK.get())).requiresCorrectToolForDrops().strength(25.0f, 600.0f)));
    public static final DeferredBlock<Block> TARNISHED_CUT_BRONZE_PILLAR = RNBlocks.registerWaxableBlock("tarnished_cut_bronze_pillar", () -> new TarnishingPillarBlock(TarnishingBronze.TarnishState.TARNISHED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)TARNISHED_BRONZE_BLOCK.get())).requiresCorrectToolForDrops().strength(50.0f, 1200.0f)));
    public static final DeferredBlock<Block> CRYSTALLIZED_CUT_BRONZE_PILLAR = RNBlocks.registerWaxableBlock("crystallized_cut_bronze_pillar", () -> new TarnishingPillarBlock(TarnishingBronze.TarnishState.CRYSTALLIZED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CRYSTALLIZED_BRONZE_BLOCK.get())).requiresCorrectToolForDrops().strength(1.0f, 6.0f)));
    public static final DeferredBlock<Block> CUT_BRONZE_BRICKS = RNBlocks.registerWaxableBlock("cut_bronze_bricks", () -> new TarnishingBronzeBlock(TarnishingBronze.TarnishState.UNAFFECTED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)BRONZE_BLOCK.get())).requiresCorrectToolForDrops().strength(5.0f, 150.0f)));
    public static final DeferredBlock<Block> DISCOLORED_CUT_BRONZE_BRICKS = RNBlocks.registerWaxableBlock("discolored_cut_bronze_bricks", () -> new TarnishingBronzeBlock(TarnishingBronze.TarnishState.DISCOLORED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DISCOLORED_BRONZE_BLOCK.get())).requiresCorrectToolForDrops().strength(15.0f, 300.0f)));
    public static final DeferredBlock<Block> CORRODED_CUT_BRONZE_BRICKS = RNBlocks.registerWaxableBlock("corroded_cut_bronze_bricks", () -> new TarnishingBronzeBlock(TarnishingBronze.TarnishState.CORRODED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CORRODED_BRONZE_BLOCK.get())).requiresCorrectToolForDrops().strength(25.0f, 600.0f)));
    public static final DeferredBlock<Block> TARNISHED_CUT_BRONZE_BRICKS = RNBlocks.registerWaxableBlock("tarnished_cut_bronze_bricks", () -> new TarnishingBronzeBlock(TarnishingBronze.TarnishState.TARNISHED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)TARNISHED_BRONZE_BLOCK.get())).requiresCorrectToolForDrops().strength(50.0f, 1200.0f)));
    public static final DeferredBlock<Block> CRYSTALLIZED_CUT_BRONZE_BRICKS = RNBlocks.registerWaxableBlock("crystallized_cut_bronze_bricks", () -> new TarnishingBronzeBlock(TarnishingBronze.TarnishState.CRYSTALLIZED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CRYSTALLIZED_BRONZE_BLOCK.get())).requiresCorrectToolForDrops().strength(1.0f, 6.0f)));
    public static final DeferredBlock<SlabBlock> CUT_BRONZE_BRICKS_SLAB = RNBlocks.registerWaxableBlock("cut_bronze_bricks_slab", () -> new TarnishingBronzeSlabBlock(TarnishingBronze.TarnishState.UNAFFECTED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)BRONZE_BLOCK.get())).requiresCorrectToolForDrops().strength(5.0f, 150.0f)));
    public static final DeferredBlock<StairBlock> CUT_BRONZE_BRICKS_STAIRS = RNBlocks.registerWaxableBlock("cut_bronze_bricks_stairs", () -> new TarnishingBronzeStairBlock(TarnishingBronze.TarnishState.UNAFFECTED, ((Block)BRONZE_BLOCK.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)BRONZE_BLOCK.get())).requiresCorrectToolForDrops().strength(5.0f, 150.0f)));
    public static final DeferredBlock<SlabBlock> DISCOLORED_CUT_BRONZE_BRICKS_SLAB = RNBlocks.registerWaxableBlock("discolored_cut_bronze_bricks_slab", () -> new TarnishingBronzeSlabBlock(TarnishingBronze.TarnishState.DISCOLORED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DISCOLORED_BRONZE_BLOCK.get())).requiresCorrectToolForDrops().strength(15.0f, 300.0f)));
    public static final DeferredBlock<StairBlock> DISCOLORED_CUT_BRONZE_BRICKS_STAIRS = RNBlocks.registerWaxableBlock("discolored_cut_bronze_bricks_stairs", () -> new TarnishingBronzeStairBlock(TarnishingBronze.TarnishState.DISCOLORED, ((Block)DISCOLORED_BRONZE_BLOCK.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DISCOLORED_BRONZE_BLOCK.get())).requiresCorrectToolForDrops().strength(15.0f, 300.0f)));
    public static final DeferredBlock<SlabBlock> CORRODED_CUT_BRONZE_BRICKS_SLAB = RNBlocks.registerWaxableBlock("corroded_cut_bronze_bricks_slab", () -> new TarnishingBronzeSlabBlock(TarnishingBronze.TarnishState.CORRODED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CORRODED_BRONZE_BLOCK.get())).requiresCorrectToolForDrops().strength(25.0f, 600.0f)));
    public static final DeferredBlock<StairBlock> CORRODED_CUT_BRONZE_BRICKS_STAIRS = RNBlocks.registerWaxableBlock("corroded_cut_bronze_bricks_stairs", () -> new TarnishingBronzeStairBlock(TarnishingBronze.TarnishState.CORRODED, ((Block)CORRODED_BRONZE_BLOCK.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CORRODED_BRONZE_BLOCK.get())).requiresCorrectToolForDrops().strength(25.0f, 600.0f)));
    public static final DeferredBlock<SlabBlock> TARNISHED_CUT_BRONZE_BRICKS_SLAB = RNBlocks.registerWaxableBlock("tarnished_cut_bronze_bricks_slab", () -> new TarnishingBronzeSlabBlock(TarnishingBronze.TarnishState.TARNISHED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)TARNISHED_BRONZE_BLOCK.get())).requiresCorrectToolForDrops().strength(50.0f, 1200.0f)));
    public static final DeferredBlock<StairBlock> TARNISHED_CUT_BRONZE_BRICKS_STAIRS = RNBlocks.registerWaxableBlock("tarnished_cut_bronze_bricks_stairs", () -> new TarnishingBronzeStairBlock(TarnishingBronze.TarnishState.TARNISHED, ((Block)TARNISHED_BRONZE_BLOCK.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)TARNISHED_BRONZE_BLOCK.get())).requiresCorrectToolForDrops().strength(50.0f, 1200.0f)));
    public static final DeferredBlock<SlabBlock> CRYSTALLIZED_CUT_BRONZE_BRICKS_SLAB = RNBlocks.registerWaxableBlock("crystallized_cut_bronze_bricks_slab", () -> new TarnishingBronzeSlabBlock(TarnishingBronze.TarnishState.CRYSTALLIZED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CRYSTALLIZED_BRONZE_BLOCK.get())).requiresCorrectToolForDrops().strength(1.0f, 6.0f)));
    public static final DeferredBlock<StairBlock> CRYSTALLIZED_CUT_BRONZE_BRICKS_STAIRS = RNBlocks.registerWaxableBlock("crystallized_cut_bronze_bricks_stairs", () -> new TarnishingBronzeStairBlock(TarnishingBronze.TarnishState.CRYSTALLIZED, ((Block)CRYSTALLIZED_BRONZE_BLOCK.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CRYSTALLIZED_BRONZE_BLOCK.get())).requiresCorrectToolForDrops().strength(1.0f, 6.0f)));
    public static final DeferredBlock<Block> BRONZE_BULB = RNBlocks.registerWaxableBlock("bronze_bulb", () -> new TarnishingBronzeBulbBlock(TarnishingBronze.TarnishState.UNAFFECTED, BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).requiresCorrectToolForDrops().strength(5.0f, 150.0f).sound(SoundType.COPPER).randomTicks().isRedstoneConductor(RNBlocks::never).lightLevel(RNBlocks.litBlockEmission(15))));
    public static final DeferredBlock<Block> DISCOLORED_BRONZE_BULB = RNBlocks.registerWaxableBlock("discolored_bronze_bulb", () -> new TarnishingBronzeBulbBlock(TarnishingBronze.TarnishState.DISCOLORED, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_PINK).requiresCorrectToolForDrops().strength(15.0f, 300.0f).sound(SoundType.COPPER).randomTicks().isRedstoneConductor(RNBlocks::never).lightLevel(RNBlocks.litBlockEmission(12))));
    public static final DeferredBlock<Block> CORRODED_BRONZE_BULB = RNBlocks.registerWaxableBlock("corroded_bronze_bulb", () -> new TarnishingBronzeBulbBlock(TarnishingBronze.TarnishState.CORRODED, BlockBehaviour.Properties.of().mapColor(MapColor.CRIMSON_STEM).requiresCorrectToolForDrops().strength(25.0f, 600.0f).sound(SoundType.COPPER).randomTicks().isRedstoneConductor(RNBlocks::never).lightLevel(RNBlocks.litBlockEmission(8))));
    public static final DeferredBlock<Block> TARNISHED_BRONZE_BULB = RNBlocks.registerWaxableBlock("tarnished_bronze_bulb", () -> new TarnishingBronzeBulbBlock(TarnishingBronze.TarnishState.TARNISHED, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_BLACK).requiresCorrectToolForDrops().strength(50.0f, 1200.0f).sound(SoundType.COPPER).randomTicks().isRedstoneConductor(RNBlocks::never).lightLevel(RNBlocks.litBlockEmission(4))));
    public static final DeferredBlock<Block> CRYSTALLIZED_BRONZE_BULB = RNBlocks.registerWaxableBlock("crystallized_bronze_bulb", () -> new TarnishingBronzeBulbBlock(TarnishingBronze.TarnishState.CRYSTALLIZED, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_WHITE).requiresCorrectToolForDrops().strength(1.0f, 6.0f).sound(SoundType.COPPER).randomTicks().isRedstoneConductor(RNBlocks::never).lightLevel(RNBlocks.litBlockEmission(15))));

    public static <T extends Block> DeferredBlock<T> registerBlockAndItem(String name, Supplier<T> block) {
        DeferredBlock register = BLOCKS.register(name, block);
        RNItems.ITEMS.registerSimpleBlockItem(name, (Supplier)register);
        return register;
    }

    public static <T extends Block> DeferredBlock<T> registerWaxableBlock(String name, Supplier<T> block) {
        DeferredBlock register = RNBlocks.registerBlockAndItem(name, block);
        RNItems.ITEMS.register("waxed_" + name, () -> new WaxableBlockItem(register, new Item.Properties()));
        return register;
    }

    private static boolean never(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return false;
    }

    private static ToIntFunction<BlockState> litBlockEmission(int lightValue) {
        return blockState -> (Boolean)blockState.getValue((Property)BlockStateProperties.LIT) != false ? lightValue : 0;
    }
}

