/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import corundum.rubinated_nether.RubinatedNether;
import corundum.rubinated_nether.client.render.entity.RubyLensModel;
import corundum.rubinated_nether.content.RNItems;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;

public class RubyLensRenderLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public static final ResourceLocation RUBY_LENS_TEXTURE = RubinatedNether.id("textures/models/wearable/ruby_lens.png");
    private final M baseModel;
    private final RubyLensModel<T> lensModel;

    public RubyLensRenderLayer(RenderLayerParent<T, M> renderer, EntityModelSet models, M baseModel) {
        super(renderer);
        this.baseModel = baseModel;
        this.lensModel = new RubyLensModel(models.bakeLayer(RubyLensModel.LAYER_LOCATION));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (livingEntity.getItemBySlot(EquipmentSlot.HEAD).is((Item)RNItems.RUBY_LENS.get())) {
            this.lensModel.copyHeadData(((HeadedModel)this.baseModel).getHead());
            this.lensModel.renderToBuffer(poseStack, buffer.getBuffer(this.lensModel.renderType(RUBY_LENS_TEXTURE)), packedLight, OverlayTexture.NO_OVERLAY, -1);
        }
    }
}

