/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import corundum.rubinated_nether.RubinatedNether;
import corundum.rubinated_nether.client.render.RNRenderTypes;
import corundum.rubinated_nether.client.render.ShaderHelper;
import corundum.rubinated_nether.content.RNItems;
import corundum.rubinated_nether.content.blocks.RubyLaserBlock;
import corundum.rubinated_nether.content.blocks.entities.RubyLaserBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionf;

public class RubyLaserRenderer
implements BlockEntityRenderer<RubyLaserBlockEntity> {
    public static final ResourceLocation LASER_TEXTURE = RubinatedNether.id("textures/misc/ruby_laser_beam.png");
    public static final ResourceLocation LASER_TEXTURE_GREYSCALE = RubinatedNether.id("textures/misc/ruby_laser_beam_greyscale.png");
    private static final int BASE_COLOR = 0xFF0000;
    private static final int TINTED_COLOR = 0x990000;
    private final Quaternionf tempQuat = new Quaternionf();

    public RubyLaserRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(RubyLaserBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        LocalPlayer player = Minecraft.getInstance().player;
        ClientLevel level = Minecraft.getInstance().level;
        if (blockEntity.alwaysVisible() || player.getItemBySlot(EquipmentSlot.HEAD).is((Item)RNItems.RUBY_LENS.get())) {
            int color;
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.5f, 0.5f);
            Direction facing = (Direction)blockEntity.getBlockState().getValue((Property)RubyLaserBlock.FACING);
            float xRot = facing == Direction.UP ? 0.0f : (Direction.Plane.VERTICAL.test(facing) ? 180.0f : 90.0f);
            float zRot = (float)(Math.max(facing.get2DDataValue(), 0) & 3) * 90.0f;
            this.tempQuat.rotationXYZ(xRot * ((float)Math.PI / 180), 0.0f, zRot * ((float)Math.PI / 180));
            float lerpedTime = Mth.lerp((float)partialTick, (float)level.getGameTime(), (float)(level.getGameTime() + 1L));
            float angle = lerpedTime * 3.0f % 360.0f;
            this.tempQuat.rotateY(angle * ((float)Math.PI / 180));
            poseStack.mulPose(this.tempQuat);
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            float maxY = (float)(blockEntity.getRenderRange() + 1.0);
            if (blockEntity.isColored()) {
                color = blockEntity.getColor().orElse(0xFF0000);
            } else if (blockEntity.isSilly()) {
                float hue = lerpedTime % 50.0f / 50.0f;
                int col = Mth.hsvToRgb((float)hue, (float)0.8f, (float)1.0f);
                color = FastColor.ARGB32.color((int)255, (int)col);
            } else {
                color = FastColor.ARGB32.color((int)255, (int)((Boolean)blockEntity.getBlockState().getValue((Property)RubyLaserBlock.TINTED) != false ? 0x990000 : 0xFF0000));
            }
            VertexConsumer consumer = buffer.getBuffer(this.getRenderType(blockEntity.isColored() || blockEntity.isSilly()));
            this.renderFace(poseStack, consumer, 0.4f, 1.0f, 0.6f, 0.6f, maxY, 0.6f, color, lerpedTime, Direction.NORTH);
            this.renderFace(poseStack, consumer, 0.6f, 1.0f, 0.4f, 0.4f, maxY, 0.4f, color, lerpedTime, Direction.SOUTH);
            this.renderFace(poseStack, consumer, 0.4f, 1.0f, 0.4f, 0.4f, maxY, 0.6f, color, lerpedTime, Direction.EAST);
            this.renderFace(poseStack, consumer, 0.6f, 1.0f, 0.6f, 0.6f, maxY, 0.4f, color, lerpedTime, Direction.WEST);
            poseStack.popPose();
        }
    }

    private void renderFace(PoseStack matrices, VertexConsumer buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, int color, float ticks, Direction face) {
        PoseStack.Pose pose = matrices.last();
        float maxV = (maxY - 1.0f) / 15.0f;
        float v0 = 1.0f - ticks % 150.0f / 150.0f;
        float v1 = v0 + maxV * 0.4f;
        int endColor = FastColor.ARGB32.color((int)(-((int)maxY - 16) * 15), (int)color);
        buffer.addVertex(pose.pose(), minX, minY, minZ).setColor(color).setUv(0.0f, v0).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(0xF000F0, 1).setNormal(pose, (float)face.getStepX(), (float)face.getStepY(), (float)face.getStepZ());
        buffer.addVertex(pose.pose(), maxX, minY, maxZ).setColor(color).setUv(1.0f, v0).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(0xF000F0, 1).setNormal(pose, (float)face.getStepX(), (float)face.getStepY(), (float)face.getStepZ());
        buffer.addVertex(pose.pose(), maxX, maxY, maxZ).setColor(endColor).setUv(1.0f, v1).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(0xF000F0, 200).setNormal(pose, (float)face.getStepX(), (float)face.getStepY(), (float)face.getStepZ());
        buffer.addVertex(pose.pose(), minX, maxY, minZ).setColor(endColor).setUv(0.0f, v1).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(0xF000F0, 200).setNormal(pose, (float)face.getStepX(), (float)face.getStepY(), (float)face.getStepZ());
    }

    public AABB getRenderBoundingBox(RubyLaserBlockEntity blockEntity) {
        Direction facing = (Direction)blockEntity.getBlockState().getValue((Property)RubyLaserBlock.FACING);
        Vec3i end = facing.getNormal().multiply(blockEntity.getCurrentRange() + 1);
        return new AABB(blockEntity.getBlockPos()).expandTowards((double)end.getX(), (double)end.getY(), (double)end.getZ());
    }

    protected RenderType getRenderType(boolean colored) {
        if (ShaderHelper.isShaderPackInUse()) {
            return RenderType.entityTranslucentEmissive((ResourceLocation)(colored ? LASER_TEXTURE_GREYSCALE : LASER_TEXTURE));
        }
        return colored ? RNRenderTypes.LASER_BEAM_GRAYSCALE : RNRenderTypes.LASER_BEAM;
    }
}

