/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.client;

import corundum.rubinated_nether.client.particles.RubinationAltarParticle;
import corundum.rubinated_nether.client.particles.RubyAuraParticle;
import corundum.rubinated_nether.client.render.entity.RubyLensModel;
import corundum.rubinated_nether.client.render.entity.RubyLensRenderLayer;
import corundum.rubinated_nether.content.RNParticleTypes;
import corundum.rubinated_nether.mixin.accessors.EntityRenderDispatcherAccessor;
import java.util.Map;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;

@OnlyIn(value=Dist.CLIENT)
public class RubinatedNetherClient {
    public static final int WHITE = -1;

    public static void client(IEventBus bussin) {
        bussin.addListener(RubinatedNetherClient::registerParticleProviders);
        bussin.addListener(RubinatedNetherClient::registerEntityLayers);
        bussin.addListener(RubinatedNetherClient::registeModelLayers);
    }

    public static void registeModelLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(RubyLensModel.LAYER_LOCATION, RubyLensModel::createBodyLayer);
    }

    public static void registerEntityLayers(EntityRenderersEvent.AddLayers event) {
        EntityRenderDispatcher dispatcher = event.getContext().getEntityRenderDispatcher();
        Map<EntityType<?>, EntityRenderer<?>> renderers = ((EntityRenderDispatcherAccessor)dispatcher).getRenderers();
        EntityModelSet models = event.getEntityModels();
        renderers.forEach((type, renderer) -> {
            LivingEntityRenderer livingRenderer;
            if (renderer instanceof LivingEntityRenderer && (livingRenderer = (LivingEntityRenderer)renderer).getModel() instanceof HeadedModel) {
                livingRenderer.addLayer(new RubyLensRenderLayer(livingRenderer, models, livingRenderer.getModel()));
            }
        });
        ((EntityRenderDispatcherAccessor)dispatcher).setRenderers(renderers);
        PlayerRenderer defaultSkin = (PlayerRenderer)event.getSkin(PlayerSkin.Model.WIDE);
        PlayerRenderer slimSkin = (PlayerRenderer)event.getSkin(PlayerSkin.Model.SLIM);
        defaultSkin.addLayer(new RubyLensRenderLayer(defaultSkin, models, (PlayerModel)defaultSkin.getModel()));
        slimSkin.addLayer(new RubyLensRenderLayer(slimSkin, models, (PlayerModel)slimSkin.getModel()));
    }

    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)RNParticleTypes.RUBY_AURA.get(), RubyAuraParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RNParticleTypes.RUBINATE.get(), RubinationAltarParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RNParticleTypes.BRONZE_SCRAPE.get(), RubinationAltarParticle.Provider::new);
    }
}

