/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import corundum.rubinated_nether.client.RubinatedNetherClient;
import corundum.rubinated_nether.content.RNArmorMaterials;
import corundum.rubinated_nether.content.RNBlockEntities;
import corundum.rubinated_nether.content.RNBlocks;
import corundum.rubinated_nether.content.RNCreativeTabs;
import corundum.rubinated_nether.content.RNEntityCreator;
import corundum.rubinated_nether.content.RNItems;
import corundum.rubinated_nether.content.RNLootInjector;
import corundum.rubinated_nether.content.RNParticleTypes;
import corundum.rubinated_nether.content.RNRecipes;
import corundum.rubinated_nether.content.RNSoundEvents;
import corundum.rubinated_nether.content.enchantment.RNEnchantmentEffects;
import corundum.rubinated_nether.content.menu.RNMenuTypes;
import corundum.rubinated_nether.content.recipe.RNRecipeCategories;
import corundum.rubinated_nether.content.recipe.RNRecipeSerializers;
import corundum.rubinated_nether.data.Datagen;
import corundum.rubinated_nether.misc.DatapackRegistry;
import corundum.rubinated_nether.utils.RNConfig;
import eu.midnightdust.lib.config.MidnightConfig;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="rubinated_nether")
public class RubinatedNether {
    public static final String MODID = "rubinated_nether";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static IEventBus IEventBus;
    private static final ImmutableList<DeferredRegister<?>> REGISTRIES;

    public RubinatedNether(IEventBus modEventBus, ModContainer modContainer, Dist dist) {
        LOGGER.info("Rubinating all over your Nether...");
        modEventBus.addListener(Datagen::datagen);
        modEventBus.addListener(DatapackRegistry::datapackRegistry);
        RNEnchantmentEffects.register(modEventBus);
        for (DeferredRegister registry : REGISTRIES) {
            registry.register(modEventBus);
        }
        MidnightConfig.init((String)MODID, RNConfig.class);
        if (dist == Dist.CLIENT) {
            RubinatedNetherClient.client(modEventBus);
            modEventBus.addListener(RNRecipeCategories::registerRecipeCategories);
        }
        RNLootInjector.init();
    }

    public static ResourceLocation id(String s) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)s);
    }

    static {
        REGISTRIES = ImmutableList.of((Object)RNBlocks.BLOCKS, (Object)RNItems.ITEMS, RNArmorMaterials.ARMOR_MATERIALS, RNEntityCreator.ENTITY_TYPES, RNParticleTypes.PARTICLES, RNSoundEvents.SOUNDS, RNCreativeTabs.CREATIVE_MODE_TABS, RNRecipes.RECIPE_TYPES, RNRecipeSerializers.RECIPE_SERIALIZERS, RNBlockEntities.BLOCK_ENTITY_TYPES, RNMenuTypes.MENUS);
    }
}

