/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.util;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.EvaluatorException;
import dev.latvian.mods.rhino.NativeArray;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public interface ArrayValueProvider {
    public static final ArrayValueProvider EMPTY = new ArrayValueProvider(){

        @Override
        public int getLength(Context cx) {
            return 0;
        }

        @Override
        public Object getArrayValue(Context cx, int index) {
            return null;
        }

        @Override
        public Object getErrorSource(Context cx) {
            return null;
        }
    };

    public int getLength(Context var1);

    public Object getArrayValue(Context var1, int var2);

    public Object getErrorSource(Context var1);

    default public Object createArray(Context cx, TypeInfo target) {
        int len = this.getLength(cx);
        Object arr = target.newArray(len);
        for (int i = 0; i < len; ++i) {
            try {
                Array.set(arr, i, cx.jsToJava(this.getArrayValue(cx, i), target));
                continue;
            }
            catch (EvaluatorException ee) {
                return cx.reportConversionError(this.getErrorSource(cx), target);
            }
        }
        return arr;
    }

    default public Object createList(Context cx, TypeInfo target) {
        int len = this.getLength(cx);
        if (len == 0) {
            return List.of();
        }
        if (len == 1) {
            try {
                return List.of(cx.jsToJava(this.getArrayValue(cx, 0), target));
            }
            catch (EvaluatorException ee) {
                return cx.reportConversionError(this.getErrorSource(cx), target);
            }
        }
        ArrayList<Object> list = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            try {
                list.add(cx.jsToJava(this.getArrayValue(cx, i), target));
                continue;
            }
            catch (EvaluatorException ee) {
                return cx.reportConversionError(this.getErrorSource(cx), target);
            }
        }
        return list;
    }

    default public Object createSet(Context cx, TypeInfo target) {
        int len = this.getLength(cx);
        if (len == 0) {
            return Set.of();
        }
        if (len == 1) {
            try {
                return Set.of(cx.jsToJava(this.getArrayValue(cx, 0), target));
            }
            catch (EvaluatorException ee) {
                return cx.reportConversionError(this.getErrorSource(cx), target);
            }
        }
        HashSet<Object> set = new HashSet<Object>(len);
        for (int i = 0; i < len; ++i) {
            try {
                set.add(cx.jsToJava(this.getArrayValue(cx, i), target));
                continue;
            }
            catch (EvaluatorException ee) {
                return cx.reportConversionError(this.getErrorSource(cx), target);
            }
        }
        return set;
    }

    public static ArrayValueProvider fromNativeArray(NativeArray array) {
        return array.getLength() == 0L ? EMPTY : new FromNativeArray(array);
    }

    public static ArrayValueProvider fromJavaList(List<?> list, Object errorSource) {
        return list.isEmpty() ? EMPTY : new FromJavaList(list, errorSource);
    }

    public static ArrayValueProvider fromIterable(Iterable<?> iterable) {
        int len;
        if (iterable instanceof Collection) {
            Collection c = (Collection)iterable;
            len = c.size();
        } else {
            len = 0;
            for (Object ignored : iterable) {
                ++len;
            }
        }
        return len == 0 ? EMPTY : new FromIterator(len, iterable.iterator(), iterable);
    }

    public record FromNativeArray(NativeArray array) implements ArrayValueProvider
    {
        @Override
        public int getLength(Context cx) {
            return (int)this.array.getLength();
        }

        @Override
        public Object getArrayValue(Context cx, int index) {
            return this.array.get(cx, index, (Scriptable)this.array);
        }

        @Override
        public Object getErrorSource(Context cx) {
            return this.array;
        }
    }

    public record FromJavaList(List<?> list, Object errorSource) implements ArrayValueProvider
    {
        @Override
        public int getLength(Context cx) {
            return this.list.size();
        }

        @Override
        public Object getArrayValue(Context cx, int index) {
            return this.list.get(index);
        }

        @Override
        public Object getErrorSource(Context cx) {
            return this.errorSource;
        }
    }

    public record FromIterator(int length, Iterator<?> iterator, Object errorSource) implements ArrayValueProvider
    {
        @Override
        public int getLength(Context cx) {
            return this.length;
        }

        @Override
        public Object getArrayValue(Context cx, int index) {
            return this.iterator.next();
        }

        @Override
        public Object getErrorSource(Context cx) {
            return this.errorSource;
        }
    }

    public record FromPlainJavaArray(Object[] array) implements ArrayValueProvider
    {
        @Override
        public int getLength(Context cx) {
            return this.array.length;
        }

        @Override
        public Object getArrayValue(Context cx, int index) {
            return this.array[index];
        }

        @Override
        public Object getErrorSource(Context cx) {
            return this.array;
        }
    }

    public record FromJavaArray(Object array, int length) implements ArrayValueProvider
    {
        @Override
        public int getLength(Context cx) {
            return this.length;
        }

        @Override
        public Object getArrayValue(Context cx, int index) {
            return Array.get(this.array, index);
        }

        @Override
        public Object getErrorSource(Context cx) {
            return this.array;
        }
    }

    public record FromObject(Object object) implements ArrayValueProvider
    {
        public static final FromObject FROM_NULL = new FromObject(null);

        @Override
        public int getLength(Context cx) {
            return 1;
        }

        @Override
        public Object getArrayValue(Context cx, int index) {
            return this.object;
        }

        @Override
        public Object getErrorSource(Context cx) {
            return this.object;
        }
    }
}

