/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mcjty.lib.varia.BlockPosTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public record SimpleDialerData(GlobalPos transmitter, int receiver, boolean onceMode) {
    public static final Codec<SimpleDialerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GlobalPos.CODEC.fieldOf("transmitter").forGetter(SimpleDialerData::transmitter), (App)Codec.INT.fieldOf("receiver").forGetter(SimpleDialerData::receiver), (App)Codec.BOOL.fieldOf("once").forGetter(SimpleDialerData::onceMode)).apply((Applicative)instance, SimpleDialerData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SimpleDialerData> STREAM_CODEC = StreamCodec.composite((StreamCodec)GlobalPos.STREAM_CODEC, d -> d.transmitter, (StreamCodec)ByteBufCodecs.INT, d -> d.receiver, (StreamCodec)ByteBufCodecs.BOOL, d -> d.onceMode, SimpleDialerData::new);

    public static SimpleDialerData createDefault() {
        return new SimpleDialerData(GlobalPos.of((ResourceKey)Level.OVERWORLD, (BlockPos)BlockPosTools.INVALID), -1, false);
    }

    public SimpleDialerData withTransmitter(GlobalPos transmitter) {
        return new SimpleDialerData(transmitter, this.receiver, this.onceMode);
    }

    public SimpleDialerData withReceiver(int receiver) {
        return new SimpleDialerData(this.transmitter, receiver, this.onceMode);
    }

    public SimpleDialerData withOnceMode(boolean onceMode) {
        return new SimpleDialerData(this.transmitter, this.receiver, onceMode);
    }
}

