/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental.recipes;

import com.google.common.collect.Maps;
import java.util.Map;
import mcjty.lib.crafting.IRecipeBuilder;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsutility.modules.environmental.recipes.SyringeBasedRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SyringeRecipeBuilder
implements IRecipeBuilder<SyringeRecipeBuilder> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Item result;
    private final int count;
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final Advancement.Builder advancementBuilder = Advancement.Builder.advancement();
    private ShapedRecipeBuilder builder;
    private String group;
    private final ResourceLocation mobId;
    private int syringeIndex;

    public SyringeRecipeBuilder(ItemLike resultIn, int countIn, ResourceLocation mobId, int syringeIndex) {
        this.result = resultIn.asItem();
        this.count = countIn;
        this.mobId = mobId;
        this.syringeIndex = syringeIndex;
        this.builder = new ShapedRecipeBuilder(RecipeCategory.MISC, (ItemLike)this.result, this.count);
    }

    public static SyringeRecipeBuilder shaped(ItemLike resultIn, ResourceLocation mobId, int syringeIndex) {
        return SyringeRecipeBuilder.shaped(resultIn, 1, mobId, syringeIndex);
    }

    public static SyringeRecipeBuilder shaped(ItemLike resultIn, int countIn, ResourceLocation mobId, int syringeIndex) {
        return new SyringeRecipeBuilder(resultIn, countIn, mobId, syringeIndex);
    }

    public SyringeRecipeBuilder define(Character symbol, TagKey<Item> tagIn) {
        this.builder = this.builder.define(symbol, Ingredient.of(tagIn));
        return this;
    }

    public SyringeRecipeBuilder define(Character symbol, ItemLike itemIn) {
        this.builder = this.builder.define(symbol, Ingredient.of((ItemLike[])new ItemLike[]{itemIn}));
        return this;
    }

    public SyringeRecipeBuilder define(Character symbol, Ingredient ingredientIn) {
        this.builder = this.builder.define(symbol, ingredientIn);
        return this;
    }

    public SyringeRecipeBuilder patternLine(String patternIn) {
        this.builder = this.builder.pattern(patternIn);
        return this;
    }

    public SyringeRecipeBuilder unlockedBy(String name, Criterion<? extends CriterionTriggerInstance> criterionIn) {
        this.builder = this.builder.unlockedBy(name, criterionIn);
        return this;
    }

    public SyringeRecipeBuilder setGroup(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public void build(RecipeOutput consumerIn) {
        this.build(consumerIn, Tools.getId((Item)this.result));
    }

    public void build(RecipeOutput consumerIn, String save) {
        ResourceLocation resourcelocation = Tools.getId((Item)this.result);
        if (ResourceLocation.parse((String)save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Shaped Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, ResourceLocation.parse((String)save));
    }

    public void build(final RecipeOutput consumerIn, ResourceLocation id) {
        final ResourceLocation mob = this.mobId;
        final int index = this.syringeIndex;
        this.builder.save(new RecipeOutput(){

            public Advancement.Builder advancement() {
                return SyringeRecipeBuilder.this.advancementBuilder;
            }

            public void accept(ResourceLocation resourceLocation, Recipe<?> recipe, @Nullable AdvancementHolder advancementHolder, ICondition ... iConditions) {
                consumerIn.accept(resourceLocation, (Recipe)new SyringeBasedRecipe((ShapedRecipe)recipe, mob, index), advancementHolder, iConditions);
            }
        });
    }
}

