/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility;

import java.util.function.Function;
import java.util.function.Supplier;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.modules.IModule;
import mcjty.lib.modules.Modules;
import mcjty.rftoolsutility.apiimpl.teleportation.TeleportationManager;
import mcjty.rftoolsutility.modules.crafter.CrafterModule;
import mcjty.rftoolsutility.modules.environmental.EnvironmentalModule;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.ScreenModuleRegistry;
import mcjty.rftoolsutility.modules.spawner.SpawnerModule;
import mcjty.rftoolsutility.modules.tank.TankModule;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.modules.teleporter.items.porter.ChargedPorterItem;
import mcjty.rftoolsutility.setup.ClientSetup;
import mcjty.rftoolsutility.setup.Config;
import mcjty.rftoolsutility.setup.ModSetup;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import mcjty.rftoolsutility.setup.Registration;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@Mod(value="rftoolsutility")
public class RFToolsUtility {
    public static final String MODID = "rftoolsutility";
    public static final ModSetup setup = new ModSetup();
    public static RFToolsUtility instance;
    private final Modules modules = new Modules();
    public static final ScreenModuleRegistry screenModuleRegistry;

    public RFToolsUtility(ModContainer mod, IEventBus bus, Dist dist) {
        instance = this;
        this.setupModules(bus, dist);
        Config.register(mod, bus, this.modules);
        Registration.register(bus);
        bus.addListener(setup::init);
        bus.addListener(arg_0 -> ((Modules)this.modules).init(arg_0));
        bus.addListener(this::processIMC);
        bus.addListener(this::onDataGen);
        bus.addListener(RFToolsUtilityMessages::registerMessages);
        bus.addListener(setup.getBlockCapabilityRegistrar(Registration.RBLOCKS));
        bus.addListener(this::onRegisterCapabilities);
        if (dist.isClient()) {
            bus.addListener(arg_0 -> ((Modules)this.modules).initClient(arg_0));
            NeoForge.EVENT_BUS.addListener(ClientSetup::renderGameOverlayEvent);
        }
    }

    public static <T extends Item> Supplier<T> tab(Supplier<T> supplier) {
        return setup.tab(supplier);
    }

    private void onDataGen(GatherDataEvent event) {
        DataGen datagen = new DataGen(MODID, event);
        this.modules.datagen(datagen, event.getLookupProvider());
        datagen.generate();
    }

    private void processIMC(InterModProcessEvent event) {
        event.getIMCStream().forEach(message -> {
            if ("getTeleportationManager".equals(message.getMethod())) {
                Supplier supplier = message.getMessageSupplier();
                ((Function)supplier.get()).apply(new TeleportationManager());
            } else if ("getScreenModuleRegistry".equalsIgnoreCase(message.getMethod())) {
                Supplier supplier = message.getMessageSupplier();
                ((Function)supplier.get()).apply(screenModuleRegistry);
            }
        });
    }

    private void setupModules(IEventBus bus, Dist dist) {
        this.modules.register((IModule)new CrafterModule(bus));
        this.modules.register((IModule)new LogicBlockModule(bus));
        this.modules.register((IModule)new ScreenModule(bus));
        this.modules.register((IModule)new SpawnerModule(bus));
        this.modules.register((IModule)new TankModule(bus, dist));
        this.modules.register((IModule)new TeleporterModule(bus));
        this.modules.register((IModule)new EnvironmentalModule(bus, dist));
    }

    private void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        Registration.ITEMS.getRegister().getEntries().forEach(entry -> {
            Item item = (Item)entry.get();
            if (item instanceof ChargedPorterItem) {
                ChargedPorterItem porter = (ChargedPorterItem)item;
                event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, context) -> porter.createEnergyStorage((ItemStack)stack), new ItemLike[]{item});
            }
        });
    }

    static {
        screenModuleRegistry = new ScreenModuleRegistry();
    }
}

