/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.api.control.parameters;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsbase.api.control.parameters.BlockSide;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.apache.commons.lang3.StringUtils;

public class Inventory
extends BlockSide {
    @Nullable
    private final Direction intSide;
    public static final Codec<Inventory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("node").forGetter(inv -> Optional.ofNullable(inv.getNodeName())), (App)Direction.CODEC.fieldOf("side").forGetter(Inventory::getSide), (App)Direction.CODEC.optionalFieldOf("int_side").forGetter(inv -> Optional.ofNullable(inv.getIntSide()))).apply((Applicative)instance, (node, side, intSide) -> new Inventory(node.orElse(null), (Direction)side, intSide.orElse(null))));
    public static final StreamCodec<RegistryFriendlyByteBuf, Inventory> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), inv -> Optional.ofNullable(inv.getNodeName()), (StreamCodec)Direction.STREAM_CODEC, Inventory::getSide, (StreamCodec)ByteBufCodecs.optional((StreamCodec)Direction.STREAM_CODEC), inv -> Optional.ofNullable(inv.intSide), (node, side, intSide) -> new Inventory(node.orElse(null), (Direction)side, intSide.orElse(null)));

    public Inventory(@Nullable String name, @Nonnull Direction side, @Nullable Direction intSide) {
        super(name, side);
        this.intSide = intSide;
    }

    public String serialize() {
        return "#" + (this.hasNodeName() ? this.getNodeName() : "-") + "#" + this.getSide().getSerializedName() + "#" + (this.intSide == null ? "-" : this.intSide.getSerializedName()) + "#";
    }

    public static Inventory deserialize(String s) {
        String[] splitted = StringUtils.split((String)s, (char)'#');
        return new Inventory("-".equals(splitted[0]) ? null : splitted[0], Direction.byName((String)splitted[1]), "-".equals(splitted[2]) ? null : Direction.byName((String)splitted[2]));
    }

    @Override
    @Nonnull
    public Direction getSide() {
        return super.getSide();
    }

    @Nullable
    public Direction getIntSide() {
        return this.intSide;
    }

    @Override
    public String getStringRepresentation() {
        Object s = StringUtils.left((String)this.getSide().getSerializedName().toUpperCase(), (int)1);
        if (this.getIntSide() == null) {
            s = (String)s + "/*";
        } else {
            String is = StringUtils.left((String)this.getIntSide().getSerializedName().toUpperCase(), (int)1);
            s = (String)s + "/" + is;
        }
        if (this.getNodeName() == null) {
            return s;
        }
        return StringUtils.left((String)this.getNodeName(), (int)6) + " " + (String)s;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Inventory inventory = (Inventory)o;
        return this.intSide == inventory.intSide;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.intSide != null ? this.intSide.hashCode() : 0);
        return result;
    }
}

