/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.repae2bridge.mixin;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.inventory.InventoryMenu;
import net.unfamily.repae2bridge.util.MatterTypeInfo;
import net.unfamily.repae2bridge.util.MatterTypeUtil;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpriteLoader.class})
public abstract class SpriteLoaderMixin {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Shadow
    @Final
    private ResourceLocation location;

    @Shadow
    public abstract SpriteLoader.Preparations stitch(List<SpriteContents> var1, int var2, Executor var3);

    @Inject(method={"loadAndStitch(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/resources/ResourceLocation;ILjava/util/concurrent/Executor;Ljava/util/Collection;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="HEAD")}, cancellable=true)
    private void rep_ae2_bridge$loadMatterSprites(ResourceManager resourceManager, ResourceLocation atlasSource, int mipLevel, Executor executor, Collection<MetadataSectionSerializer<?>> serializers, CallbackInfoReturnable<CompletableFuture<SpriteLoader.Preparations>> cir) {
        if (!this.location.equals((Object)InventoryMenu.BLOCK_ATLAS)) {
            return;
        }
        SpriteResourceLoader spriteResourceLoader = SpriteResourceLoader.create(serializers);
        CompletionStage future = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            List factories = SpriteSourceList.load((ResourceManager)resourceManager, (ResourceLocation)atlasSource).list(resourceManager);
            ArrayList<Function<SpriteResourceLoader, SpriteContents>> mutable = new ArrayList<Function<SpriteResourceLoader, SpriteContents>>(factories);
            this.rep_ae2_bridge$appendMatterFactories(mutable, resourceManager);
            return mutable;
        }, executor).thenCompose(factories -> SpriteLoader.runSpriteSuppliers((SpriteResourceLoader)spriteResourceLoader, (List)factories, (Executor)executor))).thenApply(contents -> this.stitch((List<SpriteContents>)contents, mipLevel, executor));
        cir.setReturnValue((Object)future);
    }

    @Unique
    private void rep_ae2_bridge$appendMatterFactories(List<Function<SpriteResourceLoader, SpriteContents>> factories, ResourceManager resourceManager) {
        MatterTypeUtil.loadAllMatters();
        for (MatterTypeInfo info : MatterTypeUtil.getAllMatters().values()) {
            String matterName = info.matterType().getName();
            if (matterName.equals("crystal") || matterName.equals("plasma") || matterName.equals("bio_energy")) continue;
            factories.add(loader -> this.rep_ae2_bridge$loadMatterSprite((SpriteResourceLoader)loader, info, resourceManager));
        }
    }

    @Unique
    private SpriteContents rep_ae2_bridge$loadMatterSprite(SpriteResourceLoader loader, MatterTypeInfo info, ResourceManager resourceManager) {
        ResourceLocation spriteId = info.texture();
        ResourceLocation texturePath = ResourceLocation.fromNamespaceAndPath((String)spriteId.getNamespace(), (String)("textures/" + spriteId.getPath() + ".png"));
        LOGGER.debug("Looking for matter texture at: {}", (Object)texturePath);
        Optional resourceOpt = resourceManager.getResource(texturePath);
        Resource resource = resourceOpt.orElse(null);
        if (resource == null) {
            LOGGER.warn("Matter texture not found: {} (for matter type: {})", (Object)texturePath, (Object)info.name());
            return null;
        }
        LOGGER.debug("Matter texture found, loading sprite: {}", (Object)spriteId);
        SpriteContents contents = loader.loadSprite(spriteId, resource);
        if (contents != null) {
            this.rep_ae2_bridge$applyTint(contents.getOriginalImage(), info.color());
            LOGGER.debug("Matter sprite loaded successfully: {} (for matter type: {})", (Object)spriteId, (Object)info.name());
        } else {
            LOGGER.warn("Failed to load matter sprite: {} (for matter type: {})", (Object)spriteId, (Object)info.name());
        }
        return contents;
    }

    @Unique
    private void rep_ae2_bridge$applyTint(NativeImage image, float[] color) {
        if (color == null || color.length < 3) {
            return;
        }
        float r = this.clampColor(color[0]);
        float g = this.clampColor(color[1]);
        float b = this.clampColor(color[2]);
        int height = image.getHeight();
        int width = image.getWidth();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = image.getPixelRGBA(x, y);
                int a = pixel >>> 24 & 0xFF;
                int rr = (int)Math.min(255.0f, (float)(pixel >>> 16 & 0xFF) * r);
                int gg = (int)Math.min(255.0f, (float)(pixel >>> 8 & 0xFF) * g);
                int bb = (int)Math.min(255.0f, (float)(pixel & 0xFF) * b);
                int tinted = a << 24 | bb << 16 | gg << 8 | rr;
                image.setPixelRGBA(x, y, tinted);
            }
        }
    }

    @Unique
    private float clampColor(float value) {
        return Math.max(0.0f, Math.min(1.0f, value));
    }
}

