/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.repae2bridge.item;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.unfamily.repae2bridge.data.ReplicationBridgeLoader;
import net.unfamily.repae2bridge.item.CustomMatterItem;
import net.unfamily.repae2bridge.item.MatterItem;
import net.unfamily.repae2bridge.item.UniversalMatterItem;
import org.slf4j.Logger;

public class ModItems {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"rep_ae2_bridge");
    public static final Map<String, DeferredHolder<Item, Item>> CUSTOM_MATTER_ITEMS = new HashMap<String, DeferredHolder<Item, Item>>();
    private static final Map<String, String> EXPECTED_MATTER_BINDINGS = new HashMap<String, String>();
    public static final DeferredHolder<Item, Item> EARTH_MATTER = ITEMS.register("earth", () -> new MatterItem(new Item.Properties()));
    public static final DeferredHolder<Item, Item> NETHER_MATTER = ITEMS.register("nether", () -> new MatterItem(new Item.Properties()));
    public static final DeferredHolder<Item, Item> ORGANIC_MATTER = ITEMS.register("organic", () -> new MatterItem(new Item.Properties()));
    public static final DeferredHolder<Item, Item> ENDER_MATTER = ITEMS.register("ender", () -> new MatterItem(new Item.Properties()));
    public static final DeferredHolder<Item, Item> METALLIC_MATTER = ITEMS.register("metallic", () -> new MatterItem(new Item.Properties()));
    public static final DeferredHolder<Item, Item> PRECIOUS_MATTER = ITEMS.register("precious", () -> new MatterItem(new Item.Properties()));
    public static final DeferredHolder<Item, Item> LIVING_MATTER = ITEMS.register("living", () -> new MatterItem(new Item.Properties()));
    public static final DeferredHolder<Item, Item> QUANTUM_MATTER = ITEMS.register("quantum", () -> new MatterItem(new Item.Properties()));
    public static final DeferredHolder<Item, Item> UNIVERSAL_MATTER = ITEMS.register("universal_matter", () -> new UniversalMatterItem(new Item.Properties()));

    public static void registerCustomMatterItems() {
        LOGGER.info("=== registerCustomMatterItems() CALLED ===");
        CUSTOM_MATTER_ITEMS.clear();
        try {
            ReplicationBridgeLoader.loadConfigFile();
            Map<String, String> matterDefinitions = ReplicationBridgeLoader.getMatterDefinitions();
            if (matterDefinitions.isEmpty()) {
                LOGGER.info("No custom matter definitions found in external scripts");
                LOGGER.info("=== Custom matter item registration completed. Registered {} items ===", (Object)CUSTOM_MATTER_ITEMS.size());
                return;
            }
            LOGGER.info("Found {} custom matter definitions in external scripts", (Object)matterDefinitions.size());
            for (Map.Entry<String, String> entry : matterDefinitions.entrySet()) {
                String registryName = entry.getKey();
                String matterId = entry.getValue();
                try {
                    ResourceLocation rl = ResourceLocation.parse((String)matterId);
                    String itemName = registryName;
                    LOGGER.info("Attempting to register item '{}' for matter '{}'", (Object)itemName, (Object)matterId);
                    DeferredHolder holder = ITEMS.register(itemName, () -> new CustomMatterItem(new Item.Properties(), itemName));
                    CUSTOM_MATTER_ITEMS.put(itemName, (DeferredHolder<Item, Item>)holder);
                    EXPECTED_MATTER_BINDINGS.put(itemName, matterId);
                    String displayName = ModItems.generateDisplayName(rl.getPath());
                    LOGGER.info("SUCCESS: Pre-registered custom matter item '{}' (will bind to '{}' later). Add to lang file: \"item.rep_ae2_bridge.{}\": \"{}\"", new Object[]{itemName, matterId, itemName, displayName});
                }
                catch (Exception e) {
                    LOGGER.error("FAILED: Could not register custom matter item for: {} -> {}", new Object[]{registryName, matterId, e});
                }
            }
            LOGGER.info("=== Custom matter item registration completed. Registered {} items ===", (Object)CUSTOM_MATTER_ITEMS.size());
            LOGGER.info("Available custom matter items: {}", CUSTOM_MATTER_ITEMS.keySet());
        }
        catch (Exception e) {
            LOGGER.error("Error during custom matter item registration", (Throwable)e);
        }
    }

    private static String generateDisplayName(String path) {
        String formatted = path.replace("_", " ");
        String[] words = formatted.split(" ");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(Character.toUpperCase(word.charAt(0)));
            if (word.length() <= 1) continue;
            result.append(word.substring(1).toLowerCase());
        }
        return result.toString() + " Matter";
    }

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }
}

