/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.repae2bridge.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public record MatterComponent(String matterTypeName, ResourceLocation texture, float[] color) {
    public static final Codec<MatterComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("matter_type").forGetter(MatterComponent::matterTypeName), (App)ResourceLocation.CODEC.fieldOf("texture").forGetter(MatterComponent::texture), (App)Codec.FLOAT.listOf().xmap(list -> {
        float[] arr = new float[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = ((Float)list.get(i)).floatValue();
        }
        return arr;
    }, arr -> {
        ArrayList<Float> list = new ArrayList<Float>();
        for (float v : arr) {
            list.add(Float.valueOf(v));
        }
        return list;
    }).fieldOf("color").forGetter(MatterComponent::color)).apply((Applicative)instance, MatterComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MatterComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, MatterComponent::matterTypeName, (StreamCodec)ResourceLocation.STREAM_CODEC, MatterComponent::texture, (StreamCodec)ByteBufCodecs.FLOAT.apply(ByteBufCodecs.list()).map(list -> {
        float[] arr = new float[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = ((Float)list.get(i)).floatValue();
        }
        return arr;
    }, arr -> {
        ArrayList<Float> list = new ArrayList<Float>();
        for (float v : arr) {
            list.add(Float.valueOf(v));
        }
        return list;
    }), MatterComponent::color, MatterComponent::new);

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatterComponent)) {
            return false;
        }
        MatterComponent other = (MatterComponent)o;
        return Objects.equals(this.matterTypeName, other.matterTypeName) && Objects.equals(this.texture, other.texture) && Arrays.equals(this.color, other.color);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.matterTypeName, this.texture);
        result = 31 * result + Arrays.hashCode(this.color);
        return result;
    }
}

