/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.repae2bridge;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="rep_ae2_bridge", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.IntValue BRIDGE_ENERGY_CONSUMPTION = BUILDER.comment("Energy consumption rate (AE/t) for the RepAE2Bridge").defineInRange("bridgeEnergyConsumption", 500, 0, Integer.MAX_VALUE);
    private static final ModConfigSpec.BooleanValue ENABLE_DEBUG_LOGGING = BUILDER.comment("Enable aggressive debug logging for troubleshooting (includes network state dumps and reconnection logs)").define("enableDebugLogging", false);
    private static final ModConfigSpec.ConfigValue<String> BRIDGE_CUSTOM_MATTER_CONFIG_PATH = BUILDER.comment(new String[]{"Path to directory containing replication bridge matter declaration files", "Default: 'config'"}).define("bridgeCustomMatterConfigPath", (Object)"config");
    static final ModConfigSpec SPEC = BUILDER.build();
    public static int bridgeEnergyConsumption;
    public static boolean enableDebugLogging;
    public static String bridgeCustomMatterConfigPath;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        bridgeEnergyConsumption = (Integer)BRIDGE_ENERGY_CONSUMPTION.get();
        enableDebugLogging = (Boolean)ENABLE_DEBUG_LOGGING.get();
        bridgeCustomMatterConfigPath = (String)BRIDGE_CUSTOM_MATTER_CONFIG_PATH.get();
    }
}

