/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.repae2bridge.block.custom;

import com.buuz135.replication.block.MatterPipeBlock;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block_network.INetworkDirectionalConnection;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.unfamily.repae2bridge.block.entity.RepAE2BridgeBlockEntity;
import net.unfamily.repae2bridge.item.MatterItem;
import net.unfamily.repae2bridge.item.UniversalMatterItem;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class RepAE2BridgeBl
extends BasicTileBlock<RepAE2BridgeBlockEntity>
implements INetworkDirectionalConnection {
    public static final VoxelShape SHAPE = RepAE2BridgeBl.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final MapCodec<RepAE2BridgeBl> CODEC = RepAE2BridgeBl.simpleCodec(RepAE2BridgeBl::new);
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final BooleanProperty CONNECTED = BooleanProperty.create((String)"connected");

    public RepAE2BridgeBl(BlockBehaviour.Properties properties) {
        super(properties, RepAE2BridgeBlockEntity.class);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(false)));
        this.registerWithReplicationMod();
    }

    private void registerWithReplicationMod() {
        try {
            if (MatterPipeBlock.ALLOWED_CONNECTION_BLOCKS != null) {
                MatterPipeBlock.ALLOWED_CONNECTION_BLOCKS.add(block -> block instanceof RepAE2BridgeBl);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to register block with Replication: " + e.getMessage());
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CONNECTED});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected MapCodec<? extends BasicTileBlock<RepAE2BridgeBlockEntity>> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntityType.BlockEntitySupplier<?> getTileEntityFactory() {
        return (pos, state) -> new RepAE2BridgeBlockEntity(pos, state);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(level, pos, state, entity, stack);
        if (!level.isClientSide()) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof RepAE2BridgeBlockEntity) {
                RepAE2BridgeBlockEntity blockEntity2 = (RepAE2BridgeBlockEntity)blockEntity;
                blockEntity2.handleNeighborChanged(pos);
            }
            this.updateNeighbors(level, pos, state);
        }
    }

    private void updateNeighbors(Level level, BlockPos pos, BlockState state) {
        level.sendBlockUpdated(pos, state, state, 3);
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.relative(direction);
            BlockState neighborState = level.getBlockState(neighborPos);
            level.neighborChanged(neighborPos, state.getBlock(), pos);
            if (!(neighborState.getBlock() instanceof MatterPipeBlock)) continue;
            level.sendBlockUpdated(neighborPos, neighborState, neighborState, 3);
            if (!neighborState.hasProperty((Property)MatterPipeBlock.DIRECTIONS.get(direction.getOpposite()))) continue;
            level.setBlock(neighborPos, (BlockState)neighborState.setValue((Property)MatterPipeBlock.DIRECTIONS.get(direction.getOpposite()), (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
        if (!level.isClientSide()) {
            BlockEntity blockEntity;
            Direction directionToPipe = null;
            for (Direction direction : Direction.values()) {
                if (!pos.relative(direction).equals((Object)fromPos) || !(level.getBlockState(fromPos).getBlock() instanceof MatterPipeBlock)) continue;
                directionToPipe = direction;
                break;
            }
            if ((blockEntity = level.getBlockEntity(pos)) instanceof RepAE2BridgeBlockEntity) {
                BlockState pipeState;
                boolean isConnected;
                RepAE2BridgeBlockEntity blockEntity2 = (RepAE2BridgeBlockEntity)blockEntity;
                blockEntity2.handleNeighborChanged(fromPos);
                boolean bl = isConnected = blockEntity2.isActive() && blockEntity2.getNetwork() != null;
                if ((Boolean)state.getValue((Property)CONNECTED) != isConnected) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(isConnected)), 3);
                }
                if (directionToPipe != null && (pipeState = level.getBlockState(fromPos)).getBlock() instanceof MatterPipeBlock) {
                    level.sendBlockUpdated(fromPos, pipeState, pipeState, 3);
                }
            }
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity;
            if (!level.isClientSide) {
                ItemStack itemStack = new ItemStack((ItemLike)this);
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)itemStack);
            }
            if ((blockEntity = level.getBlockEntity(pos)) instanceof RepAE2BridgeBlockEntity) {
                RepAE2BridgeBlockEntity blockEntity2 = (RepAE2BridgeBlockEntity)blockEntity;
                InventoryComponent<RepAE2BridgeBlockEntity> inventory = blockEntity2.getOutput();
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    ItemStack stack = inventory.getStackInSlot(i);
                    if (stack.isEmpty() || stack.getItem() instanceof MatterItem || stack.getItem() instanceof UniversalMatterItem) continue;
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
                }
                blockEntity2.disconnectFromNetworks();
            }
            level.removeBlockEntity(pos);
        }
        super.onRemove(state, level, pos, newState, moving);
    }

    public boolean canConnect(Level level, BlockPos pos, BlockState state, Direction direction) {
        return true;
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return true;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RepAE2BridgeBlockEntity) {
            RepAE2BridgeBlockEntity blockEntity2 = (RepAE2BridgeBlockEntity)blockEntity;
            try {
                blockEntity2.onLoad();
            }
            catch (RuntimeException e) {
                if (e.getMessage() != null && e.getMessage().contains("Element network is null")) {
                    LOGGER.warn("Bridge: Replication network still not ready, scheduling another retry");
                    level.scheduleTick(pos, (Block)this, 20);
                }
                LOGGER.error("Bridge: Unexpected error during network retry: {}", (Object)e.getMessage());
            }
        }
    }
}

