/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_twilight_forest.network;

import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.Random;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ExecutionEffectPacket(int entityId, Color color) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ExecutionEffectPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"reliquified_twilight_forest", (String)"execution_effect"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ExecutionEffectPacket> STREAM_CODEC = CustomPacketPayload.codec(ExecutionEffectPacket::write, ExecutionEffectPacket::new);

    public ExecutionEffectPacket(RegistryFriendlyByteBuf buf) {
        this(buf.readInt(), new Color(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt()));
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.color.getRed());
        buf.writeInt(this.color.getGreen());
        buf.writeInt(this.color.getBlue());
        buf.writeInt(this.color.getAlpha());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ExecutionEffectPacket packet, IPayloadContext ctx) {
        if (ctx.flow().isServerbound()) {
            return;
        }
        ctx.enqueueWork(() -> {
            Level level = ctx.player().level();
            Random random = new Random();
            Entity patt0$temp = level.getEntity(packet.entityId);
            if (!(patt0$temp instanceof LivingEntity)) {
                return;
            }
            LivingEntity entity = (LivingEntity)patt0$temp;
            AABB aabb = entity.getBoundingBox();
            double size = aabb.getSize();
            int i = 0;
            while ((double)i < size * 32.0) {
                level.addParticle(ParticleUtils.constructSimpleSpark((Color)packet.color(), (float)0.5f, (int)entity.getRandom().nextInt(40, 60), (float)random.nextFloat(0.9f, 0.97f)), entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), 0.0, (double)random.nextFloat(0.005f, 0.05f), 0.0);
                ++i;
            }
        });
    }
}

