/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_twilight_forest.item.relic;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.octostudios.reliquified_twilight_forest.init.ItemRegistry;
import it.hurts.octostudios.reliquified_twilight_forest.network.ScaledCloakWallClimbPacket;
import it.hurts.octostudios.reliquified_twilight_forest.util.MathButCool;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

@EventBusSubscriber
public class ScaledCloakItem
extends RelicItem
implements IRenderableCurio {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"wall_crawler").stat(StatData.builder((String)"max_time").initialValue(60.0, 100.0).upgradeModifier(UpgradeOperation.ADD, 40.0).formatValue(MathButCool::ticksToSecondsAndRoundSingleDigit).build()).maxLevel(10).build()).ability(AbilityData.builder((String)"elusive_stare").requiredLevel(5).requiredPoints(2).stat(StatData.builder((String)"chance").initialValue(0.1, 0.25).upgradeModifier(UpgradeOperation.ADD, 0.1).formatValue(MathButCool::percentage).build()).maxLevel(10).build()).build()).leveling(LevelingData.builder().sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"wall_crawler").gem(GemShape.SQUARE, GemColor.YELLOW).build()).source(LevelingSourceData.abilityBuilder((String)"elusive_stare").gem(GemShape.SQUARE, GemColor.ORANGE).build()).build()).maxLevel(15).build()).style(StyleData.builder().beams(BeamsData.builder().startColor(-16066048).endColor(85803).build()).tooltip(TooltipData.builder().borderTop(-12172211).borderBottom(-13028028).textured(true).build()).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Item item;
        LivingEntity entity = slotContext.entity();
        Level level = entity.level();
        int time = (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.TIME, (Object)0);
        boolean isColliding = false;
        if (!level.isClientSide || entity != Minecraft.getInstance().player || !((item = stack.getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        if (entity.horizontalCollision) {
            isColliding = true;
            Vec3 deltaMovement = entity.getDeltaMovement();
            float deltaY = time > 0 ? 0.1f : -0.07f;
            entity.setDeltaMovement(deltaMovement.x, (double)deltaY, deltaMovement.z);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new ScaledCloakWallClimbPacket(isColliding), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @SubscribeEvent
    public static void onDamage(LivingIncomingDamageEvent e) {
        ScaledCloakItem relic;
        ItemStack stack;
        LivingEntity entity;
        block3: {
            block2: {
                Item item;
                entity = e.getEntity();
                Entity attacker = e.getSource().getEntity();
                EntityHitResult result = ScaledCloakItem.getEntityLookingAt(entity, 100.0);
                stack = EntityUtils.findEquippedCurio((Entity)entity, (Item)((Item)ItemRegistry.SCALED_CLOAK.get()));
                if (entity.level().isClientSide || result == null || result.getEntity() != attacker || !((item = stack.getItem()) instanceof ScaledCloakItem)) break block2;
                relic = (ScaledCloakItem)item;
                if (!((double)entity.getRandom().nextFloat() > relic.getStatValue(stack, "elusive_stare", "chance"))) break block3;
            }
            return;
        }
        relic.spreadRelicExperience(entity, stack, 1);
        entity.level().playSound(null, (Entity)entity, SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.NEUTRAL, 0.6f, 1.35f);
        e.setCanceled(true);
    }

    public static EntityHitResult getEntityLookingAt(LivingEntity livingEntity, double maxDistance) {
        Vec3 eyePosition = livingEntity.getEyePosition(1.0f);
        Vec3 lookVector = livingEntity.getViewVector(1.0f);
        Vec3 reachEnd = eyePosition.add(lookVector.scale(maxDistance));
        return ProjectileUtil.getEntityHitResult((Entity)livingEntity, (Vec3)eyePosition, (Vec3)reachEnd, (AABB)livingEntity.getBoundingBox().expandTowards(lookVector.scale(maxDistance)).inflate(1.0), entity -> entity instanceof LivingEntity && entity.isAlive() && livingEntity.hasLineOfSight(entity) && entity != livingEntity, (double)(maxDistance * maxDistance));
    }

    public String getConfigRoute() {
        return "reliquified_twilight_forest";
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<String> headParts() {
        return List.of("head");
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<String> bodyParts() {
        return List.of("right_arm", "left_arm", "body");
    }

    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(11, 37).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.3f)).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(11, 37).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.3f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-0.1913f, (float)-0.0619f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(36, 10).addBox(-2.5f, 0.0f, -3.0f, 7.0f, 3.0f, 5.0f, new CubeDeformation(0.05f)), PartPose.offsetAndRotation((float)-1.1f, (float)0.0f, (float)3.95f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(38, 41).addBox(-4.5f, 0.0f, -1.0f, 9.0f, 19.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.001f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        matrixStack.pushPose();
        LivingEntity entity = slotContext.entity();
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
        model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)this.getTexture(stack)), (boolean)stack.hasFoil());
        model.renderToBuffer(matrixStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
    }
}

