/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_lenders_cataclysm.utils;

import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ItemUtils {
    public static void resetMovementAttribute(LivingEntity entity, ItemStack stack, float value) {
        EntityUtils.resetAttribute((LivingEntity)entity, (ItemStack)stack, (Holder)Attributes.MOVEMENT_SPEED, (float)value, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE);
    }

    public static void removeMovementAttribute(LivingEntity entity, ItemStack stack) {
        EntityUtils.removeAttribute((LivingEntity)entity, (ItemStack)stack, (Holder)Attributes.MOVEMENT_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE);
    }

    public static void playCooldownSound(Level level, LivingEntity entity) {
        level.playSound(null, entity.blockPosition(), (SoundEvent)SoundEvents.NOTE_BLOCK_BELL.value(), SoundSource.PLAYERS, 2.0f, 1.0f);
    }

    public static List<LivingEntity> getEntitiesInArea(LivingEntity caster, Level level, AABB area) {
        return level.getEntities(null, area).stream().map(entity -> {
            if (!(entity instanceof LivingEntity)) return null;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity.equals((Object)caster)) return null;
            if (EntityUtils.isAlliedTo((Entity)entity, (Entity)caster)) return null;
            if (entity instanceof ArmorStand) return null;
            LivingEntity livingEntity2 = livingEntity;
            return livingEntity2;
        }).filter(Objects::nonNull).toList();
    }

    public static int getIntStat(ItemStack stack, String ability, String stat) {
        return (int)Math.round(((IRelicItem)stack.getItem()).getStatValue(stack, ability, stat));
    }

    private static int getTickStat(IRelicItem relic, ItemStack stack, String ability, String stat) {
        return (int)Math.floor(relic.getStatValue(stack, ability, stat) * 20.0);
    }

    public static int getTickStat(ItemStack stack, String ability, String stat) {
        return ItemUtils.getTickStat((IRelicItem)stack.getItem(), stack, ability, stat);
    }

    public static int getCooldownStat(ItemStack stack, String ability) {
        return ItemUtils.getTickStat((IRelicItem)stack.getItem(), stack, ability, "cooldown");
    }
}

