/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_lenders_cataclysm.items.relics.charm;

import it.hurts.octostudios.reliquified_lenders_cataclysm.init.ItemRegistry;
import it.hurts.octostudios.reliquified_lenders_cataclysm.items.base.RECItem;
import it.hurts.octostudios.reliquified_lenders_cataclysm.items.base.data.RECLootEntries;
import it.hurts.octostudios.reliquified_lenders_cataclysm.utils.ItemUtils;
import it.hurts.octostudios.reliquified_lenders_cataclysm.utils.RECMathUtils;
import it.hurts.octostudios.reliquified_lenders_cataclysm.utils.relics.ScouringEyeUtils;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.PredicateType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class ScouringEyeItem
extends RECItem {
    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"glowing_scour").active(CastData.builder().type(CastType.INSTANTANEOUS).predicate("target", PredicateType.CAST, (player, stack) -> !ScouringEyeUtils.getTargetUUID(stack).isEmpty()).predicate("tp_allowed", PredicateType.CAST, (player, stack) -> ScouringEyeUtils.isTeleportAllowed(stack)).build()).stat(StatData.builder((String)"cooldown").initialValue(20.0, 15.0).upgradeModifier(UpgradeOperation.ADD, -1.0).formatValue(RECMathUtils::roundOneDigit).build()).stat(StatData.builder((String)"glowing_time").initialValue(10.0, 12.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.525).formatValue(RECMathUtils::roundInt).build()).build()).build()).leveling(LevelingData.builder().initialCost(100).step(100).maxLevel(10).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"glowing_scour").gem(GemShape.SQUARE, GemColor.PURPLE).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{RECLootEntries.CURSED_PYRAMID, LootEntries.THE_END}).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-6196783).borderBottom(-8109653).textured(true).build()).beams(BeamsData.builder().startColor(-12188841).endColor(11020230).build()).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        Level level = entity.level();
        if (level.isClientSide) {
            return;
        }
        LivingEntity target = ScouringEyeUtils.getEntityFromStack(level, stack);
        if (target == null) {
            return;
        }
        if (target.isDeadOrDying()) {
            ScouringEyeUtils.resetData(stack);
            return;
        }
        ScouringEyeUtils.setTeleportSafe(stack, ScouringEyeUtils.getTeleportPos(entity, target) != null);
        int glowingTime = ScouringEyeUtils.getGlowingTime(stack);
        if (glowingTime <= 0) {
            return;
        }
        int stackTime = ScouringEyeUtils.getStackTime(stack);
        if (glowingTime == 1) {
            level.playSound(null, entity.blockPosition(), SoundEvents.AMETHYST_BLOCK_BREAK, SoundSource.PLAYERS);
        }
        int gameTime = (int)level.getGameTime();
        if (stackTime == 0) {
            stackTime = gameTime;
            --glowingTime;
        } else {
            int deltaTime = gameTime - stackTime;
            if (deltaTime > 0) {
                stackTime += deltaTime;
                glowingTime -= deltaTime;
            }
        }
        ScouringEyeUtils.setStackTime(stack, stackTime);
        ScouringEyeUtils.setGlowingTime(stack, glowingTime);
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (!ability.equals("glowing_scour")) {
            return;
        }
        Level level = player.getCommandSenderWorld();
        if (level.isClientSide) {
            return;
        }
        LivingEntity target = ScouringEyeUtils.getEntityFromStack(level, stack);
        if (target == null) {
            return;
        }
        BlockPos teleportPos = ScouringEyeUtils.getTeleportPos((LivingEntity)player, target);
        if (teleportPos == null) {
            ScouringEyeUtils.setTeleportSafe(stack, false);
            return;
        }
        Vec3 teleportMovement = ScouringEyeUtils.getMovementOnTeleport(teleportPos, target.blockPosition()).scale(0.12);
        ScouringEyeUtils.teleportToTarget(player, target, teleportPos, teleportMovement);
        this.setAbilityCooldown(stack, "glowing_scour", ItemUtils.getCooldownStat(stack, "glowing_scour"));
        this.spreadRelicExperience((LivingEntity)player, stack, 1);
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent.Post event) {
        Projectile projectile;
        Player player = null;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Projectile && (entity = (projectile = (Projectile)entity).getOwner()) instanceof Player) {
            Player ownerPlayer;
            player = ownerPlayer = (Player)entity;
        } else {
            entity = event.getSource().getEntity();
            if (entity instanceof Player) {
                Player sourcePlayer;
                player = sourcePlayer = (Player)entity;
            }
        }
        if (player == null) {
            return;
        }
        Level level = player.getCommandSenderWorld();
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.SCOURING_EYE.get()));
        LivingEntity target = event.getEntity();
        if (level.isClientSide || stack.isEmpty() || target.isDeadOrDying() || target.equals((Object)player)) {
            return;
        }
        ScouringEyeUtils.setStackTime(stack, (int)level.getGameTime());
        ScouringEyeUtils.setGlowingTime(stack, ScouringEyeUtils.getGlowingTimeStat(stack));
        ScouringEyeUtils.setTargetUUID(stack, target.getUUID().toString());
        ScouringEyeUtils.setPlayerDied(stack, false);
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.SCOURING_EYE.get()));
        if (player.getCommandSenderWorld().isClientSide || stack.isEmpty()) {
            return;
        }
        ScouringEyeUtils.setPlayerDied(stack, true);
    }
}

