/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_lenders_cataclysm.items.relics.back;

import com.github.L_Ender.cataclysm.entity.projectile.Void_Rune_Entity;
import it.hurts.octostudios.reliquified_lenders_cataclysm.init.ItemRegistry;
import it.hurts.octostudios.reliquified_lenders_cataclysm.init.RECDataComponentRegistry;
import it.hurts.octostudios.reliquified_lenders_cataclysm.items.base.RECItem;
import it.hurts.octostudios.reliquified_lenders_cataclysm.items.base.data.RECLootEntries;
import it.hurts.octostudios.reliquified_lenders_cataclysm.utils.ItemUtils;
import it.hurts.octostudios.reliquified_lenders_cataclysm.utils.RECMathUtils;
import it.hurts.octostudios.reliquified_lenders_cataclysm.utils.relics.VoidCloakUtils;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class VoidCloakItem
extends RECItem {
    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"void_invulnerability").build()).ability(AbilityData.builder((String)"void_rune").active(CastData.builder().type(CastType.TOGGLEABLE).build()).stat(StatData.builder((String)"cooldown").initialValue(20.0, 16.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.05625).formatValue(RECMathUtils::roundOneDigit).build()).stat(StatData.builder((String)"damage").initialValue(1.4, 1.76).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.525).formatValue(RECMathUtils::roundDamage).build()).build()).ability(AbilityData.builder((String)"seismic_zone").requiredLevel(5).stat(StatData.builder((String)"radius").initialValue(2.0, 3.0).upgradeModifier(UpgradeOperation.ADD, 0.5).formatValue(RECMathUtils::roundInt).build()).stat(StatData.builder((String)"waves").initialValue(2.0, 3.0).upgradeModifier(UpgradeOperation.ADD, 0.5).formatValue(RECMathUtils::roundInt).build()).stat(StatData.builder((String)"damage").initialValue(1.4, 1.76).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.525).formatValue(RECMathUtils::roundDamage).build()).build()).build()).leveling(LevelingData.builder().initialCost(100).step(100).maxLevel(15).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"void_rune").gem(GemShape.SQUARE, GemColor.PURPLE).build()).source(LevelingSourceData.abilityBuilder((String)"seismic_zone").gem(GemShape.SQUARE, GemColor.ORANGE).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{RECLootEntries.CURSED_PYRAMID, RECLootEntries.FROSTED_PRISON, LootEntries.THE_END}).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-4616238).borderBottom(-7774812).textured(true).build()).beams(BeamsData.builder().startColor(-4616238).endColor(16310422).build()).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        block10: {
            block9: {
                LivingEntity livingEntity;
                if (stack.isEmpty() || !((livingEntity = slotContext.entity()) instanceof Player)) break block9;
                player = (Player)livingEntity;
                if (this.isAbilityTicking(stack, "void_rune")) break block10;
            }
            return;
        }
        Level level = player.getCommandSenderWorld();
        if (level.isClientSide) {
            return;
        }
        int voidRuneCooldown = (Integer)stack.getOrDefault(RECDataComponentRegistry.VOID_RUNE_TIME, (Object)0);
        if (voidRuneCooldown > 0) {
            --voidRuneCooldown;
        } else {
            List<LivingEntity> entitiesInArea = ItemUtils.getEntitiesInArea((LivingEntity)player, level, player.getBoundingBox().inflate(10.0));
            boolean runeSpawned = false;
            for (LivingEntity entity : entitiesInArea) {
                if (entity == null || entity.equals((Object)player) || entity instanceof ArmorStand || EntityUtils.isAlliedTo((Entity)player, (Entity)entity)) continue;
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    LivingEntity targetEntity = mob.getTarget();
                    if (targetEntity == null || !targetEntity.is((Entity)player)) continue;
                    VoidCloakUtils.spawnVoidRune(level, player, (LivingEntity)mob, stack);
                    runeSpawned = true;
                    break;
                }
                VoidCloakUtils.spawnVoidRune(level, player, entity, stack);
                runeSpawned = true;
                break;
            }
            if (runeSpawned) {
                voidRuneCooldown = ItemUtils.getCooldownStat(stack, "void_rune");
            }
        }
        stack.set(RECDataComponentRegistry.VOID_RUNE_TIME, (Object)voidRuneCooldown);
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingIncomingDamageEvent event) {
        Item item;
        Void_Rune_Entity voidRuneEntity;
        Entity entity = event.getSource().getDirectEntity();
        if (!(entity instanceof Void_Rune_Entity) || !((entity = (voidRuneEntity = (Void_Rune_Entity)entity).getCaster()) instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.VOID_CLOAK.get()));
        if (stack.isEmpty() || !((item = stack.getItem()) instanceof VoidCloakItem)) {
            return;
        }
        VoidCloakItem relic = (VoidCloakItem)item;
        relic.spreadRelicExperience((LivingEntity)player, stack, 1);
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingIncomingDamageEvent event) {
        ItemStack stack;
        Void_Rune_Entity voidRuneEntity;
        LivingEntity caster;
        Player player;
        block7: {
            block6: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block6;
                player = (Player)livingEntity;
                if (!player.getCommandSenderWorld().isClientSide) break block7;
            }
            return;
        }
        Entity entity = event.getSource().getDirectEntity();
        if (entity instanceof Void_Rune_Entity && (caster = (voidRuneEntity = (Void_Rune_Entity)entity).getCaster()) != null && caster.getUUID().equals(player.getUUID())) {
            event.setCanceled(true);
        }
        if ((stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.VOID_CLOAK.get()))).isEmpty() || !(stack.getItem() instanceof VoidCloakItem)) {
            return;
        }
        if (player.getY() < (double)player.getCommandSenderWorld().getMinBuildHeight()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        VoidCloakItem relic;
        Player entityOwnerPlayer;
        LivingEntity entity = event.getEntity();
        Player player = null;
        if (entity instanceof Player) {
            player = (Player)entity;
        } else if (entity instanceof OwnableEntity) {
            OwnableEntity ownableEntity = (OwnableEntity)entity;
            LivingEntity entityOwner = ownableEntity.getOwner();
            if (!(entityOwner instanceof Player)) {
                return;
            }
            entityOwnerPlayer = (Player)entityOwner;
            player = entityOwnerPlayer;
        }
        if (player == null) {
            return;
        }
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.VOID_CLOAK.get()));
        if (stack.isEmpty() || !((entityOwnerPlayer = stack.getItem()) instanceof VoidCloakItem) || !(relic = (VoidCloakItem)entityOwnerPlayer).isAbilityUnlocked(stack, "seismic_zone")) {
            return;
        }
        Level level = player.getCommandSenderWorld();
        if (level.isClientSide) {
            return;
        }
        level.explode((Entity)player, entity.getX(), entity.getY(), entity.getZ(), 1.0f, false, Level.ExplosionInteraction.NONE);
        VoidCloakUtils.spawnSeismicZone(level, player, entity, stack);
        relic.spreadRelicExperience((LivingEntity)player, stack, 5);
    }
}

