/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.mixin;

import com.hollingsworth.arsnouveau.common.entity.EntityOrbitProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.charm.EmblemOfDevotionItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityOrbitProjectile.class})
public abstract class EntityOrbitProjectileMixin
extends EntityProjectileSpell {
    public EntityOrbitProjectileMixin(EntityType<? extends EntityProjectileSpell> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onEntityInside(CallbackInfo ci) {
        EntityOrbitProjectile orbit = (EntityOrbitProjectile)this;
        if (orbit.spellResolver == null) {
            return;
        }
        Entity player = orbit.getOwner();
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.EMBLEM_OF_DEVOTION.value()));
        if (!(orbit.spellResolver.spellContext.getCasterTool().getItem() instanceof EmblemOfDevotionItem) || !stack.isEmpty()) {
            return;
        }
        orbit.getCommandSenderWorld().broadcastEntityEvent((Entity)orbit, (byte)3);
        orbit.remove(Entity.RemovalReason.DISCARDED);
    }

    @Inject(method={"onHit"}, at={@At(value="HEAD")})
    protected void onHitEntity(HitResult result, CallbackInfo ci) {
        EntityOrbitProjectile entity = (EntityOrbitProjectile)this;
        if (entity.spellResolver == null || !(result instanceof EntityHitResult)) {
            return;
        }
        Entity player = entity.getOwner();
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.EMBLEM_OF_DEVOTION.value()));
        Item item = entity.spellResolver.spellContext.getCasterTool().getItem();
        if (!(item instanceof EmblemOfDevotionItem)) {
            return;
        }
        EmblemOfDevotionItem relic = (EmblemOfDevotionItem)item;
        relic.spreadRelicExperience((LivingEntity)player, stack, 1);
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        EntityOrbitProjectile entity = (EntityOrbitProjectile)this;
        if (entity.spellResolver == null) {
            return;
        }
        Entity player = entity.getOwner();
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.EMBLEM_OF_DEVOTION.value()));
        Item item = entity.spellResolver.spellContext.getCasterTool().getItem();
        if (!(item instanceof EmblemOfDevotionItem)) {
            return;
        }
        EmblemOfDevotionItem relic = (EmblemOfDevotionItem)item;
        relic.addCharges(stack, -1);
    }
}

