/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.items.hands;

import com.google.common.collect.Lists;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.event.SpellCostCalcEvent;
import com.hollingsworth.arsnouveau.api.particle.timelines.ProjectileTimeline;
import com.hollingsworth.arsnouveau.api.registry.ParticleTimelineRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.init.RANDataComponentRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.NouveauRelicItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.ScribbleRelicItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.base.loot.LootEntries;
import it.hurts.octostudios.reliquified_ars_nouveau.items.hands.MulticastedComponent;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class ArchmageGloveItem
extends NouveauRelicItem
implements IRenderableCurio {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"multicasted").stat(StatData.builder((String)"chance").initialValue(0.15, 0.25).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)0)).build()).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"multicasted").initialValue(1).gem(GemShape.SQUARE, GemColor.ORANGE).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-8039364).borderBottom(-8039364).textured(true).build()).beams(BeamsData.builder().startColor(-1100904).endColor(12784992).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.ARS_NOUVEAU, LootEntries.ARS_NOUVEAU_LIKE}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide() || !stack.has(RANDataComponentRegistry.MULTICASTED) || this.getListMulticasted(stack) == null || this.getListMulticasted(stack).isEmpty()) {
            return;
        }
        ArrayList<MulticastedComponent> multicastedListComponent = new ArrayList<MulticastedComponent>(this.getListMulticasted(stack));
        for (int i = 0; i < multicastedListComponent.size(); ++i) {
            MulticastedComponent multicastedComponent = multicastedListComponent.get(i);
            SpellCaster spellCaster = multicastedComponent.spellCaster();
            int tickSpell = multicastedComponent.tickSpell();
            int multicastCount = multicastedComponent.multicastCount();
            String id = multicastedComponent.id();
            Entity target = null;
            if (!id.equals("empty")) {
                target = ((ServerLevel)player.getCommandSenderWorld()).getEntity(UUID.fromString(id));
            }
            if (multicastCount == 0 || target != null && !target.isAlive()) {
                multicastedListComponent.remove(i);
                this.setListMulticasted(stack, multicastedListComponent);
                return;
            }
            multicastedListComponent.set(i, new MulticastedComponent(multicastCount, tickSpell - 1, spellCaster, id));
            if (tickSpell != 0) continue;
            this.onCasted(stack, player, player.getCommandSenderWorld(), player.getUsedItemHand(), spellCaster, id);
            multicastedListComponent.set(i, new MulticastedComponent(multicastCount - 1, 4, spellCaster, id));
        }
        this.setListMulticasted(stack, multicastedListComponent);
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        block3: {
            block2: {
                LivingEntity livingEntity = slotContext.entity();
                if (!(livingEntity instanceof Player)) break block2;
                Player player = (Player)livingEntity;
                if (prevStack.getItem() != stack.getItem() && stack.has(RANDataComponentRegistry.MULTICASTED)) break block3;
            }
            return;
        }
        this.setListMulticasted(stack, Collections.emptyList());
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        matrixStack.pushPose();
        LivingEntity entity = slotContext.entity();
        model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
        VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)this.getTexture(stack)), (boolean)stack.hasFoil());
        model.renderToBuffer(matrixStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition partdefinition = mesh.getRoot();
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.offset((float)-5.5f, (float)1.0f, (float)0.25f));
        PartDefinition perchatka = right_arm.addOrReplaceChild("perchatka", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -2.5f, -2.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 11).addBox(0.0f, 3.5f, -2.5f, 3.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(16, 11).addBox(3.0f, 0.5f, -3.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.005f)), PartPose.offset((float)-3.0f, (float)7.7f, (float)-0.25f));
        PartDefinition bone = perchatka.addOrReplaceChild("bone", CubeListBuilder.create().texOffs(0, 17).addBox(-1.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)32, (int)32);
    }

    public List<String> bodyParts() {
        return Lists.newArrayList((Object[])new String[]{"right_arm"});
    }

    public void onCasted(ItemStack stack, Player player, Level level, InteractionHand handIn, SpellCaster spellCaster, String id) {
        PlayerCaster wrappedCaster = new PlayerCaster(player);
        SpellResolver resolver = spellCaster.getSpellResolver(new SpellContext(level, spellCaster.getSpell(), (LivingEntity)player, (IWrappedCaster)wrappedCaster, stack), level, (LivingEntity)player, handIn);
        resolver.spellContext.setCasterTool(stack);
        boolean isSensitive = resolver.spell.getBuffsAtIndex(0, (LivingEntity)player, (AbstractAugment)AugmentSensitive.INSTANCE) > 0;
        HitResult result = SpellUtil.rayTrace((Entity)player, (double)(0.5 + player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue()), (float)0.0f, (boolean)isSensitive);
        Entity target = null;
        if (!id.equals("empty")) {
            target = ((ServerLevel)level).getEntity(UUID.fromString(id));
        }
        if (target != null) {
            if (resolver.onCastOnEntity(stack, target, handIn)) {
                spellCaster.playSound(player.getOnPos(), level, (Entity)player, spellCaster.getCurrentSound(), SoundSource.PLAYERS);
            }
        } else {
            EntityHitResult entityHitResult;
            if (result instanceof EntityHitResult && resolver.onCastOnEntity(stack, (entityHitResult = (EntityHitResult)result).getEntity(), handIn)) {
                spellCaster.playSound(player.getOnPos(), level, (Entity)player, spellCaster.getCurrentSound(), SoundSource.PLAYERS);
            }
            if (result instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)result;
                if ((result.getType() == HitResult.Type.BLOCK || isSensitive) && resolver.onCastOnBlock(new UseOnContext(player, handIn, blockHitResult))) {
                    spellCaster.playSound(player.getOnPos(), level, (Entity)player, spellCaster.getCurrentSound(), SoundSource.PLAYERS);
                }
            }
            if (resolver.onCast(stack, level)) {
                spellCaster.playSound(player.getOnPos(), level, (Entity)player, spellCaster.getCurrentSound(), SoundSource.PLAYERS);
            }
        }
    }

    public List<MulticastedComponent> getListMulticasted(ItemStack stack) {
        return (List)stack.get(RANDataComponentRegistry.MULTICASTED);
    }

    public void setListMulticasted(ItemStack stack, List<MulticastedComponent> multicasted) {
        stack.set(RANDataComponentRegistry.MULTICASTED, multicasted);
    }

    @EventBusSubscriber
    public static class ArchmageGloveEvent {
        @SubscribeEvent
        public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            List<ItemStack> stacks = EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)ItemRegistry.ARCHMAGE_GLOVE.value())).stream().filter(stack -> stack.has(RANDataComponentRegistry.MULTICASTED)).toList();
            if (stacks.isEmpty()) {
                return;
            }
            for (ItemStack stack2 : stacks) {
                stack2.set(RANDataComponentRegistry.MULTICASTED, null);
            }
        }

        @SubscribeEvent
        public static void onCostMana(SpellCostCalcEvent event) {
            LivingEntity entity;
            LivingCaster livingEntity;
            block6: {
                block5: {
                    IWrappedCaster iWrappedCaster = event.context.getCaster();
                    if (!(iWrappedCaster instanceof LivingCaster)) {
                        return;
                    }
                    livingEntity = (LivingCaster)iWrappedCaster;
                    entity = livingEntity.livingEntity;
                    ItemStack stack = EntityUtils.findEquippedCurio((Entity)entity, (Item)((Item)ItemRegistry.ARCHMAGE_GLOVE.value()));
                    Item item = stack.getItem();
                    if (!(item instanceof ArchmageGloveItem)) break block5;
                    ArchmageGloveItem relic = (ArchmageGloveItem)item;
                    if (event.context.getCasterTool().is(ItemRegistry.ARCHMAGE_GLOVE)) break block6;
                }
                return;
            }
            event.currentCost = 0;
            if (livingEntity.livingEntity.getCommandSenderWorld().isClientSide()) {
                return;
            }
            Level level = entity.getCommandSenderWorld();
            RandomSource random = level.getRandom();
            level.playSound(null, (Entity)entity, SoundEvents.ALLAY_ITEM_TAKEN, SoundSource.PLAYERS, 1.0f, 0.9f + random.nextFloat() * 0.2f);
            ((ServerLevel)level).sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(100 + random.nextInt(156), random.nextInt(100 + random.nextInt(156)), random.nextInt(100 + random.nextInt(156))), (float)0.3f, (int)40, (float)0.8f), entity.getX(), entity.getY() + 0.4, entity.getZ(), 30, 0.1, 0.1, 0.1, 0.1);
        }

        @SubscribeEvent
        public static void onCastSpell(SpellCastEvent event) {
            IWrappedCaster iWrappedCaster;
            block7: {
                block6: {
                    iWrappedCaster = event.context.getCaster();
                    if (!(iWrappedCaster instanceof LivingCaster)) break block6;
                    LivingCaster caster = (LivingCaster)iWrappedCaster;
                    iWrappedCaster = caster.livingEntity;
                    if (iWrappedCaster instanceof Player) break block7;
                }
                return;
            }
            Player player = (Player)iWrappedCaster;
            int color = ((ProjectileTimeline)event.context.getSpell().particleTimeline().get((Supplier)ParticleTimelineRegistry.PROJECTILE_TIMELINE)).trailEffect().particleOptions().colorProp().color().getColor();
            int red = color >> 16 & 0xFF;
            int green = color >> 8 & 0xFF;
            int blue = color & 0xFF;
            if (red >= 200 && green <= 150 && blue >= 150 && red >= blue) {
                ArchmageGloveItem relic;
                ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.ARCHMAGE_GLOVE.value()));
                ItemStack casterTool = event.context.getCasterTool();
                Item item = stack.getItem();
                if (!(item instanceof ArchmageGloveItem) || !(relic = (ArchmageGloveItem)item).isAbilityUnlocked(stack, "multicasted") || casterTool.is(ItemRegistry.ARCHMAGE_GLOVE) || casterTool.getItem() instanceof ScribbleRelicItem) {
                    return;
                }
                int multicast = Math.min(5, MathUtils.multicast((RandomSource)player.getRandom(), (double)relic.getStatValue(stack, "multicasted", "chance")));
                if (multicast == 0) {
                    return;
                }
                relic.spreadRelicExperience((LivingEntity)player, stack, multicast);
                ArrayList<MulticastedComponent> lists = new ArrayList<MulticastedComponent>(relic.getListMulticasted(stack) == null ? Collections.emptyList() : relic.getListMulticasted(stack));
                lists.add(new MulticastedComponent(multicast * EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)ItemRegistry.ARCHMAGE_GLOVE.value())).size(), 4, (SpellCaster)new SpellCaster().setSpell(event.context.getSpell()), "empty"));
                relic.setListMulticasted(stack, lists);
            }
        }
    }
}

