/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.items;

import com.hollingsworth.arsnouveau.api.event.SpellCostCalcEvent;
import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import com.hollingsworth.arsnouveau.client.gui.SpellTooltip;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.config.Config;
import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.NouveauRelicItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.hands.ArchmageGloveItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.hands.MulticastedComponent;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public abstract class ScribbleRelicItem
extends NouveauRelicItem
implements IScribeable {
    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, world, entity, slot, selected);
        if (!stack.has((Supplier)com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry.SPELL_CASTER)) {
            stack.set((Supplier)com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry.SPELL_CASTER, (Object)((SpellCaster)new SpellCaster().setSpell(new Spell())));
        }
    }

    public boolean onScribe(Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, ItemStack itemStack) {
        ItemStack heldStack = player.getItemInHand(interactionHand);
        AbstractCaster heldCaster = SpellCasterRegistry.from((ItemStack)heldStack);
        if (heldCaster == null) {
            return false;
        }
        Spell.Mutable spell = heldCaster.getSpell().mutable();
        ArrayList recipe = new ArrayList(spell.recipe);
        for (AbstractSpellPart entry : recipe) {
            if (!(entry instanceof AbstractCastMethod) || entry instanceof MethodTouch) continue;
            PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.translatable((String)"reliquified_ars_nouveau.can_not_set_spell"));
            return false;
        }
        if (itemStack.getItem() instanceof ScribbleRelicItem && this.getCountGlyphInItem(itemStack) < spell.recipe.size()) {
            PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.translatable((String)"reliquified_ars_nouveau.has_low_level_relic"));
            return false;
        }
        spell.setRecipe(recipe);
        ((SpellCaster)this.getSpellCaster(itemStack).setSpell(spell.immutable())).saveToStack(itemStack);
        PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.translatable((String)"ars_nouveau.set_spell"));
        return true;
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        SpellCaster caster = this.getSpellCaster(stack);
        if (caster == null) {
            return Optional.empty();
        }
        return (Boolean)Config.GLYPH_TOOLTIPS.get() != false && !caster.isSpellHidden() && caster.getSpell().recipe().iterator().hasNext() ? Optional.of(new SpellTooltip((AbstractCaster)caster)) : Optional.empty();
    }

    public abstract int getCountGlyphInItem(ItemStack var1);

    public void onAutoCastedSpell(Player player, LivingEntity target, ItemStack stack, Color color) {
        ArchmageGloveItem relic;
        SpellCaster caster = this.getSpellCaster(stack);
        if (caster == null) {
            return;
        }
        Level level = player.getCommandSenderWorld();
        InteractionHand usedHand = player.getUsedItemHand();
        SpellContext context = new SpellContext(player.level(), this.getSpellCaster(stack).getSpell(), (LivingEntity)player, (IWrappedCaster)new PlayerCaster(player));
        context.setCasterTool(stack);
        caster.getSpellResolver(context, level, (LivingEntity)player, usedHand).onCastOnEntity(stack, (Entity)target, usedHand);
        caster.playSound(player.getOnPos(), level, (Entity)player, caster.getCurrentSound(), SoundSource.PLAYERS);
        ItemStack archmageStack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.ARCHMAGE_GLOVE.value()));
        RandomSource random = player.getRandom();
        Item item = archmageStack.getItem();
        if (item instanceof ArchmageGloveItem && (relic = (ArchmageGloveItem)item).isAbilityUnlocked(archmageStack, "multicasted")) {
            int multicast = Math.min(5, MathUtils.multicast((RandomSource)random, (double)relic.getStatValue(archmageStack, "multicasted", "chance")));
            relic.spreadRelicExperience((LivingEntity)player, archmageStack, multicast);
            ArrayList<MulticastedComponent> lists = new ArrayList<MulticastedComponent>(relic.getListMulticasted(archmageStack) == null ? Collections.emptyList() : relic.getListMulticasted(archmageStack));
            lists.add(new MulticastedComponent(multicast * EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)ItemRegistry.ARCHMAGE_GLOVE.value())).size(), 4, caster, target.getUUID().toString()));
            relic.setListMulticasted(archmageStack, lists);
        }
        DeferredHolder tag = DataComponentRegistry.TIME;
        Optional curiosInv = CuriosApi.getCuriosInventory((LivingEntity)player);
        int relicCount = curiosInv.map(inventory -> inventory.findCurios(stack1 -> stack1.is(stack.getItem()) && stack1.has((Supplier)tag) && (Integer)stack1.get((Supplier)tag) <= 0).size()).orElse(0);
        if (curiosInv.flatMap(inventory -> inventory.findCurios(stack1 -> stack1.is(stack.getItem())).stream().map(SlotResult::slotContext).filter(slotContext -> !slotContext.visible()).findFirst()).isPresent() || relicCount > 1) {
            return;
        }
        Vec3 start = new Vec3(player.getX(), player.getY() + (double)(player.getBbHeight() / 2.0f), player.getZ());
        Vec3 end = new Vec3(target.getX(), target.getY() + (double)(target.getBbHeight() / 2.0f), target.getZ());
        int steps = Math.max(3, Math.round(player.distanceTo((Entity)target)) * 2);
        ArrayList<Vec3> points = new ArrayList<Vec3>();
        points.add(start);
        ScribbleRelicItem.addPoints(points, start, end, random, 1.3, steps);
        points.add(end);
        ScribbleRelicItem.renderLightningLine(player, points, 25, color);
        for (int n = 0; n <= 3; ++n) {
            ArrayList<Vec3> shortPoints = new ArrayList<Vec3>();
            shortPoints.add(start);
            int minSteps = Math.max(1, steps / 2);
            ScribbleRelicItem.addPoints(shortPoints, start, end, random, (double)random.nextInt(12, 15) / 15.0, random.nextInt(minSteps, Math.max(minSteps + 1, steps)));
            ScribbleRelicItem.renderLightningLine(player, shortPoints, 20, color);
        }
    }

    public SpellCaster getSpellCaster(ItemStack stack) {
        return (SpellCaster)stack.get((Supplier)com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry.SPELL_CASTER);
    }

    private static void addPoints(ArrayList<Vec3> arrayPoint, Vec3 start, Vec3 end, RandomSource random, double offsetRange, double steps) {
        int i = 1;
        while ((double)i < steps) {
            float t = (float)i / 5.0f;
            double x = start.x() + (end.x() - start.x()) * (double)t + (random.nextDouble() - 0.5) * offsetRange;
            double y = start.y() + (end.y() - start.y()) * (double)t + (random.nextDouble() - 0.5) * 1.2;
            double z = start.z() + (end.z() - start.z()) * (double)t + (random.nextDouble() - 0.5) * offsetRange;
            arrayPoint.add(new Vec3(x, y, z));
            ++i;
        }
    }

    private static void renderLightningLine(Player player, List<Vec3> points, int lineSteps, Color color) {
        for (int i = 0; i < points.size() - 1; ++i) {
            Vec3 start = points.get(i);
            Vec3 end = points.get(i + 1);
            for (int j = 0; j <= lineSteps; ++j) {
                float t = (float)j / (float)lineSteps;
                double x = start.x + (end.x - start.x) * (double)t;
                double y = start.y + (end.y - start.y) * (double)t;
                double z = start.z + (end.z - start.z) * (double)t;
                ((ServerLevel)player.getCommandSenderWorld()).sendParticles(ParticleUtils.constructSimpleSpark((Color)color, (float)0.15f, (int)20, (float)0.85f), x, y, z, 1, 0.0, 0.0, 0.0, 0.001);
            }
        }
    }

    @EventBusSubscriber
    public static class ScribbleRelicEvent {
        @SubscribeEvent
        public static void onCostMana(SpellCostCalcEvent event) {
            Item item;
            IWrappedCaster iWrappedCaster = event.context.getCaster();
            if (!(iWrappedCaster instanceof LivingCaster)) {
                return;
            }
            LivingCaster livingEntity = (LivingCaster)iWrappedCaster;
            LivingEntity entity = livingEntity.livingEntity;
            SpellContext spellContext = event.context;
            if (entity.getCommandSenderWorld().isClientSide() || !((item = spellContext.getCasterTool().getItem()) instanceof ScribbleRelicItem)) {
                return;
            }
            ScribbleRelicItem relic = (ScribbleRelicItem)item;
            event.currentCost = 0;
        }
    }
}

