/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.items;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.MageBlock;
import com.hollingsworth.arsnouveau.common.block.tile.MageBlockTile;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.NouveauRelicItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.base.loot.LootEntries;
import it.hurts.sskirillss.relics.init.CreativeTabRegistry;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.misc.CreativeContentConstructor;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;

public class ArchitectsStaffItem
extends NouveauRelicItem {
    private Vec3 startPos = Vec3.ZERO;

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"designer").stat(StatData.builder((String)"periodicity").initialValue(20.0, 15.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.05).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).stat(StatData.builder((String)"count").initialValue(1.0, 3.0).upgradeModifier(UpgradeOperation.ADD, 0.5).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"distance").initialValue(16.0, 32.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.275).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"designer").initialValue(1).gem(GemShape.SQUARE, GemColor.CYAN).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-7711393).borderBottom(-7711393).textured(true).build()).beams(BeamsData.builder().startColor(-197496).endColor(12784992).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.ARS_NOUVEAU, LootEntries.ARS_NOUVEAU_LIKE}).build()).build();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (level.isClientSide() || this.getCharge(stack) < 1) {
            return InteractionResultHolder.pass((Object)stack);
        }
        Vec3 view = player.getViewVector(0.0f);
        Vec3 eyeVec = player.getEyePosition(0.0f);
        int distance = (int)Math.round(this.getStatValue(stack, "designer", "distance"));
        BlockHitResult ray = level.clip(new ClipContext(eyeVec, eyeVec.add(view.x * (double)distance, view.y * (double)distance, view.z * (double)distance), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        this.startPos = Vec3.atLowerCornerOf((Vec3i)ray.getBlockPos());
        player.startUsingItem(usedHand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        Player player;
        block4: {
            block3: {
                if (!(livingEntity instanceof Player)) break block3;
                player = (Player)livingEntity;
                if (!level.isClientSide()) break block4;
            }
            return;
        }
        Vec3 view = player.getViewVector(0.0f);
        Vec3 eyeVec = player.getEyePosition(0.0f);
        int distance = (int)Math.round(this.getStatValue(stack, "designer", "distance"));
        BlockHitResult ray = level.clip(new ClipContext(eyeVec, eyeVec.add(view.x * (double)distance, view.y * (double)distance, view.z * (double)distance), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        BlockPos start = BlockPos.containing((Position)this.startPos);
        BlockPos end = ray.getBlockPos();
        int steps = Math.max(Math.max(Math.abs(end.getX() - start.getX()), Math.abs(end.getY() - start.getY())), Math.abs(end.getZ() - start.getZ()));
        ParticleColor color = ParticleColor.makeRandomColor((int)255, (int)255, (int)255, (RandomSource)player.getRandom());
        for (int i = 0; i <= steps; ++i) {
            double t = (double)i / (double)steps;
            BlockPos blockPos = new BlockPos((int)Mth.lerp((double)t, (double)start.getX(), (double)end.getX()), (int)Mth.lerp((double)t, (double)start.getY(), (double)end.getY()), (int)Mth.lerp((double)t, (double)start.getZ(), (double)end.getZ()));
            if (level.getBlockState(blockPos).isSolid()) continue;
            level.setBlockAndUpdate(blockPos, (BlockState)((MageBlock)BlockRegistry.MAGE_BLOCK.get()).defaultBlockState().setValue((Property)MageBlock.TEMPORARY, (Comparable)Boolean.valueOf(true)));
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (!(blockEntity instanceof MageBlockTile)) continue;
            MageBlockTile tile = (MageBlockTile)blockEntity;
            tile.color = color;
            tile.lengthModifier = 9.0;
            tile.isPermanent = false;
            Vec3 centerBlock = blockPos.getCenter();
            level.playSound(null, (Entity)player, SoundEvents.AMETHYST_CLUSTER_STEP, SoundSource.PLAYERS, 0.75f, 0.7f + player.getRandom().nextFloat() * 0.2f);
            level.sendBlockUpdated(blockPos, level.getBlockState(blockPos), level.getBlockState(blockPos), 2);
            ((ServerLevel)level).sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(color.getColor()), (float)0.3f, (int)70, (float)0.9f), centerBlock.x(), centerBlock.y(), centerBlock.z(), 5, 0.1, 0.1, 0.1, 0.1);
        }
        this.spreadRelicExperience((LivingEntity)player, stack, 1);
        this.addCharges(stack, -1);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        block5: {
            block4: {
                if (!(entity instanceof Player)) break block4;
                Player player = (Player)entity;
                if ((long)this.getCharge(stack) <= Math.round(this.getStatValue(stack, "designer", "count"))) break block5;
            }
            return;
        }
        int periodicity = (int)Math.round(this.getStatValue(stack, "designer", "periodicity")) * 20;
        this.addTime(stack, 1);
        if (this.getTime(stack) >= periodicity) {
            this.addCharges(stack, 1);
            this.setTime(stack, 0);
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.getCharge(stack) < this.getMaxCharges(stack);
    }

    public int getBarWidth(ItemStack stack) {
        float max = this.getMaxCharges(stack);
        float current = this.getCharge(stack);
        return Math.round(13.0f * current / max);
    }

    public void gatherCreativeTabContent(CreativeContentConstructor constructor) {
        ItemStack stack = this.getDefaultInstance();
        this.setCharge(stack, (int)Math.round(this.getStatValue(stack, "designer", "count")));
        constructor.entry((CreativeModeTab)CreativeTabRegistry.RELICS_TAB.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS, new ItemStack[]{stack});
    }

    public int getBarColor(ItemStack stack) {
        return Mth.hsvToRgb((float)((float)this.getCharge(stack) / (float)this.getMaxCharges(stack) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public int getMaxCharges(ItemStack stack) {
        return (int)Math.round(this.getStatValue(stack, "designer", "count"));
    }

    public int getCharge(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.CHARGE, (Object)0);
    }

    public void setCharge(ItemStack stack, int charge) {
        stack.set((Supplier)DataComponentRegistry.CHARGE, (Object)Math.max(charge, 0));
    }

    public void addCharges(ItemStack stack, int charge) {
        this.setCharge(stack, this.getCharge(stack) + charge);
    }

    public void addTime(ItemStack stack, int time) {
        this.setTime(stack, this.getTime(stack) + time);
    }

    public int getTime(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.TIME, (Object)0);
    }

    public void setTime(ItemStack stack, int val) {
        stack.set((Supplier)DataComponentRegistry.TIME, (Object)Math.max(val, 0));
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }
}

