/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.entities;

import it.hurts.octostudios.reliquified_ars_nouveau.init.EntityRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.back.WhirlingBroomItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhirlingBroomEntity
extends Mob {
    protected static EntityDataAccessor<Integer> DATA_ID = SynchedEntityData.defineId(WhirlingBroomEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private float wobbleAngle = 0.0f;

    public WhirlingBroomEntity(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        super.tick();
        Player owner = (Player)this.getFirstPassenger();
        if (owner == null) {
            if (this.tickCount >= 5) {
                this.discard();
            }
        } else {
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)owner, (Item)((Item)ItemRegistry.WHIRLING_BROOM.value()));
            Item item = stack.getItem();
            if (!(item instanceof WhirlingBroomItem)) {
                this.discard();
                return;
            }
            WhirlingBroomItem relic = (WhirlingBroomItem)item;
            Level level = this.getCommandSenderWorld();
            if (!level.isClientSide()) {
                if (owner.tickCount % 100 == 0) {
                    this.heal(1.0f);
                }
                if (this.tickCount % 20 == 0 && this.getKnownMovement().length() >= 0.2) {
                    relic.spreadRelicExperience((LivingEntity)owner, stack, 1);
                }
            }
            this.setYRot(owner.getYRot());
            this.setXRot(owner.getXRot());
            this.fallDistance = 0.0f;
            this.yBodyRot = this.yHeadRot = this.getYRot();
            this.yRotO = this.yHeadRot;
            if (this.getDeltaMovement().length() <= 0.15) {
                this.wobbleAngle += 0.1f;
                Vec3 look = this.getLookAngle().normalize();
                Vec3 side = new Vec3(-look.z, 0.0, look.x).normalize();
                double newX = this.getX() + side.x * Math.sin(this.wobbleAngle) * 0.05;
                double newY = this.getY() + Math.cos(this.wobbleAngle * 2.0f) * 0.02;
                double newZ = this.getZ() + side.z * Math.sin(this.wobbleAngle) * 0.05;
                if (level.noCollision((Entity)this, this.getBoundingBox().move(newX - this.getX(), newY - this.getY(), newZ - this.getZ()))) {
                    this.setPos(newX, newY, newZ);
                }
            }
            if (this.getDeltaMovement().length() < 0.6) {
                return;
            }
            double modifier = relic.getToggled(stack) ? 1.3 : 0.7;
            for (int i = 0; i < (relic.getToggled(stack) ? 30 : 10); ++i) {
                double offsetX = (this.random.nextDouble() - 0.5) * modifier;
                double offsetZ = (this.random.nextDouble() - 0.5) * modifier;
                level.addParticle(ParticleUtils.constructSimpleSpark((Color)new Color(this.random.nextInt(50), 80 + this.random.nextInt(175), this.random.nextInt(50)), (float)0.3f, (int)20, (float)0.7f), this.getX() + offsetX - this.getDeltaMovement().x, this.getY() + (this.random.nextDouble() - (double)0.3f), this.getZ() + offsetZ - this.getDeltaMovement().z, 0.0, 0.0, 0.0);
            }
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        return (LivingEntity)this.getFirstPassenger();
    }

    @NotNull
    public Vec3 getPassengerRidingPosition(@NotNull Entity entity) {
        return super.getPassengerRidingPosition(entity).add(0.0, -0.3, 0.0);
    }

    public void die(DamageSource damageSource) {
        Player owner = (Player)this.getFirstPassenger();
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)owner, (Item)((Item)ItemRegistry.WHIRLING_BROOM.value()));
        Item item = stack.getItem();
        if (!(item instanceof WhirlingBroomItem)) {
            return;
        }
        WhirlingBroomItem relic = (WhirlingBroomItem)item;
        relic.setAbilityCooldown(stack, "broom", 1200);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID, (Object)0);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("BroomMaxHealth")) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)compound.getFloat("BroomMaxHealth"));
        }
        if (compound.contains("BroomCurrentHealth")) {
            this.setHealth(compound.getFloat("BroomCurrentHealth"));
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        WhirlingBroomItem relic;
        super.addAdditionalSaveData(compound);
        compound.putFloat("BroomMaxHealth", this.getMaxHealth());
        Player owner = (Player)this.getFirstPassenger();
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)owner, (Item)((Item)ItemRegistry.WHIRLING_BROOM.value()));
        Item item = stack.getItem();
        if (item instanceof WhirlingBroomItem && (relic = (WhirlingBroomItem)item).getHealth(stack) > 0.0f) {
            compound.putFloat("BroomCurrentHealth", relic.getHealth(stack));
        } else {
            compound.putFloat("BroomCurrentHealth", this.getHealth());
        }
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    protected boolean canRide(Entity entity) {
        return entity instanceof Player;
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
    public static class RegistryAttributesHandlerEvent {
        @SubscribeEvent
        public static void onRegisterAttributes(EntityAttributeCreationEvent event) {
            event.put((EntityType)EntityRegistry.WHIRLING_BROOM.get(), Mob.createMobAttributes().add(Attributes.STEP_HEIGHT, 5.0).add(Attributes.MAX_HEALTH, 2.0).build());
        }
    }
}

