/*
 * Decompiled with CFR 0.152.
 */
package reliquary.potions;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import org.jetbrains.annotations.Nullable;
import reliquary.init.ModEffects;

public class FlightEffect
extends MobEffect {
    public FlightEffect() {
        super(MobEffectCategory.BENEFICIAL, 0xFFFFFF);
        NeoForge.EVENT_BUS.addListener(this::onEffectExpired);
        NeoForge.EVENT_BUS.addListener(this::onEffectRemoved);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (livingEntity.level().isClientSide) {
            return true;
        }
        if (!(livingEntity instanceof Player)) {
            return false;
        }
        Player player = (Player)livingEntity;
        AttributeInstance creativeFlightAttribute = player.getAttribute(NeoForgeMod.CREATIVE_FLIGHT);
        if (creativeFlightAttribute != null && creativeFlightAttribute.getValue() == 0.0) {
            creativeFlightAttribute.setBaseValue(1.0);
            ((ServerPlayer)player).connection.send((Packet)new ClientboundPlayerAbilitiesPacket(player.getAbilities()));
        }
        player.fallDistance = 0.0f;
        return true;
    }

    public void removeAttributeModifiers(AttributeMap attributeMap) {
        super.removeAttributeModifiers(attributeMap);
    }

    private void onEffectExpired(MobEffectEvent.Expired event) {
        FlightEffect.removeFlight(event.getEntity(), event.getEffectInstance());
    }

    private void onEffectRemoved(MobEffectEvent.Remove event) {
        FlightEffect.removeFlight(event.getEntity(), event.getEffectInstance());
    }

    private static void removeFlight(LivingEntity entity, @Nullable MobEffectInstance effectInstance) {
        if (effectInstance == null || !((MobEffect)effectInstance.getEffect().value()).equals(ModEffects.FLIGHT.value())) {
            return;
        }
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)entity;
        if (!serverPlayer.isCreative()) {
            AttributeInstance creativeFlightAttribute = serverPlayer.getAttribute(NeoForgeMod.CREATIVE_FLIGHT);
            if (creativeFlightAttribute != null) {
                creativeFlightAttribute.setBaseValue(0.0);
            }
            serverPlayer.getAbilities().flying = false;
            serverPlayer.connection.send((Packet)new ClientboundPlayerAbilitiesPacket(serverPlayer.getAbilities()));
        }
    }
}

