/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.gui.hud;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import reliquary.client.gui.components.Box;
import reliquary.client.gui.components.Component;
import reliquary.client.gui.components.ItemStackPane;
import reliquary.init.ModItems;

public class HandgunPane
extends Component {
    private final Box mainPane;
    private final ItemStackPane[] bulletPanes = new ItemStackPane[8];
    private final ItemStackPane magazinePane;
    private final InteractionHand hand;

    public HandgunPane(InteractionHand hand) {
        this.hand = hand;
        this.magazinePane = new ItemStackPane(ModItems.EMPTY_MAGAZINE.get());
        for (int i = 0; i < 8; ++i) {
            this.bulletPanes[i] = new ItemStackPane(this, ItemStack.EMPTY){

                @Override
                public int getPadding() {
                    return -3;
                }
            };
        }
        Box bulletsPane = new Box(this, Box.Layout.HORIZONTAL, Box.Alignment.MIDDLE, (Component[])this.bulletPanes){

            @Override
            public int getPadding() {
                return 3;
            }
        };
        this.mainPane = hand == InteractionHand.OFF_HAND ? Box.createHorizontal(Box.Alignment.MIDDLE, new ItemStackPane(ModItems.HANDGUN.get()), this.magazinePane, bulletsPane) : Box.createHorizontal(Box.Alignment.MIDDLE, bulletsPane, this.magazinePane, new ItemStackPane(ModItems.HANDGUN.get()));
    }

    @Override
    public int getHeightInternal() {
        return this.mainPane.getHeight();
    }

    @Override
    public int getWidthInternal() {
        return this.mainPane.getWidth();
    }

    @Override
    public int getHeight() {
        return this.holdsHandgun() ? super.getHeight() : 0;
    }

    @Override
    public boolean shouldRender() {
        return this.holdsHandgun();
    }

    private boolean holdsHandgun() {
        return Minecraft.getInstance().player.getItemInHand(this.hand).getItem() == ModItems.HANDGUN.get();
    }

    @Override
    public void renderInternal(GuiGraphics guiGraphics, int x, int y) {
        ItemStack handgun = Minecraft.getInstance().player.getItemInHand(this.hand);
        if (handgun.isEmpty()) {
            return;
        }
        ItemStack bullets = ModItems.HANDGUN.get().getBulletStack(handgun);
        for (int i = 0; i < 8; ++i) {
            if (i < bullets.getCount()) {
                this.bulletPanes[i].setItemStack(bullets);
                continue;
            }
            this.bulletPanes[i].setItemStack(ItemStack.EMPTY);
        }
        if (bullets.isEmpty() && System.currentTimeMillis() / 500L % 2L == 0L) {
            this.magazinePane.setItem(ModItems.EMPTY_MAGAZINE.get());
        } else {
            this.magazinePane.setItemStack(ItemStack.EMPTY);
        }
        this.mainPane.render(guiGraphics, x, y);
    }
}

