/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.gui.components;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import org.joml.Matrix4f;

public abstract class Component {
    public int getPadding() {
        return 1;
    }

    public int getHeight() {
        return this.getHeightInternal() + this.getPadding() * 2;
    }

    public int getWidth() {
        return this.getWidthInternal() + this.getPadding() * 2;
    }

    public void render(GuiGraphics guiGraphics, int x, int y) {
        this.renderInternal(guiGraphics, x + this.getPadding(), y + this.getPadding());
    }

    public boolean shouldRender() {
        return true;
    }

    public abstract int getHeightInternal();

    public abstract int getWidthInternal();

    public abstract void renderInternal(GuiGraphics var1, int var2, int var3);

    protected void blit(GuiGraphics guiGraphics, int x, int y, int textureX, int textureY, int width, int height, float textureWidth, float textureHeight) {
        float minU = (float)textureX / textureWidth;
        float maxU = (float)(textureX + width) / textureWidth;
        float minV = (float)textureY / textureHeight;
        float maxV = (float)(textureY + height) / textureHeight;
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        buffer.addVertex(matrix4f, (float)x, (float)(y + height), 0.0f).setUv(minU, maxV);
        buffer.addVertex(matrix4f, (float)(x + width), (float)(y + height), 0.0f).setUv(maxU, maxV);
        buffer.addVertex(matrix4f, (float)(x + width), (float)y, 0.0f).setUv(maxU, minV);
        buffer.addVertex(matrix4f, (float)x, (float)y, 0.0f).setUv(minU, minV);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }
}

