/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import reliquary.crafting.FragmentRecipeHelper;
import reliquary.init.ModItems;

public class FragmentToSpawnEggRecipe
extends ShapelessRecipe {
    private final ShapelessRecipe recipeDelegate;

    public FragmentToSpawnEggRecipe(ShapelessRecipe recipeDelegate) {
        super(recipeDelegate.getGroup(), CraftingBookCategory.MISC, recipeDelegate.result, recipeDelegate.getIngredients());
        this.recipeDelegate = recipeDelegate;
    }

    public boolean matches(CraftingInput inv, Level level) {
        return super.matches(inv, level) && FragmentRecipeHelper.hasOnlyOneFragmentType(inv);
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        return FragmentRecipeHelper.getRegistryName(inv).map(FragmentRecipeHelper::getSpawnEggStack).orElse(new ItemStack((ItemLike)FragmentRecipeHelper.FALL_BACK_SPAWN_EGG));
    }

    public RecipeSerializer<?> getSerializer() {
        return ModItems.FRAGMENT_TO_SPAWN_EGG_SERIALIZER.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<FragmentToSpawnEggRecipe> {
        private static final MapCodec<FragmentToSpawnEggRecipe> CODEC = RecipeSerializer.SHAPELESS_RECIPE.codec().xmap(FragmentToSpawnEggRecipe::new, recipe -> recipe.recipeDelegate);
        private static final StreamCodec<RegistryFriendlyByteBuf, FragmentToSpawnEggRecipe> STREAM_CODEC = RecipeSerializer.SHAPELESS_RECIPE.streamCodec().map(FragmentToSpawnEggRecipe::new, recipe -> recipe.recipeDelegate);

        public MapCodec<FragmentToSpawnEggRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FragmentToSpawnEggRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

