/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.StringTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

class ComponentSubtypeInterpreter
implements ISubtypeInterpreter<ItemStack> {
    private final Set<DataComponentType<?>> componentsToConsider;
    private static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");

    ComponentSubtypeInterpreter(DataComponentType<?> ... componentsToConsider) {
        this.componentsToConsider = new HashSet(Arrays.asList(componentsToConsider));
    }

    public String getLegacyStringSubtypeInfo(ItemStack itemStack, UidContext context) {
        DataComponentPatch componentsPatch = itemStack.getComponentsPatch();
        return componentsPatch.isEmpty() ? "" : this.getComponentsString(componentsPatch);
    }

    private String handleEscape(String keyName) {
        return SIMPLE_VALUE.matcher(keyName).matches() ? keyName : StringTag.quoteAndEscape((String)keyName);
    }

    private String getComponentsString(DataComponentPatch componentsPatch) {
        StringBuilder stringbuilder = new StringBuilder("{");
        componentsPatch.entrySet().stream().filter(entry -> this.componentsToConsider.contains(entry.getKey())).forEach(entry -> {
            if (stringbuilder.length() != 1) {
                stringbuilder.append(',');
            }
            stringbuilder.append(this.handleEscape(((DataComponentType)entry.getKey()).toString())).append(':').append(((Optional)entry.getValue()).toString());
        });
        return stringbuilder.append('}').toString();
    }

    @Nullable
    public Object getSubtypeData(ItemStack ingredient, UidContext context) {
        boolean allNulls = true;
        ArrayList<@Nullable V> results = new ArrayList(this.componentsToConsider.size());
        for (Map.Entry entry : ingredient.getComponentsPatch().entrySet()) {
            if (!this.componentsToConsider.contains(entry.getKey())) continue;
            allNulls = false;
            results.add(entry.getValue());
        }
        return allNulls ? null : results;
    }
}

