/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.init;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import reliquary.init.ModItems;
import reliquary.item.BulletItem;
import reliquary.item.MobCharmFragmentItem;
import reliquary.item.MobCharmItem;
import reliquary.item.VoidTearItem;

public class ModItemColors {
    private ModItemColors() {
    }

    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        ModItemColors.registerMobCharmItemColors(event);
        ModItemColors.registerBulletItemColors(event);
        ModItemColors.registerPotionItemColors(event);
        ModItemColors.registerVoidTearItemColors(event);
    }

    private static void registerVoidTearItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            ItemStack containedStack;
            if (Screen.hasShiftDown() && !(containedStack = VoidTearItem.getTearContents(stack)).isEmpty()) {
                return Minecraft.getInstance().getItemColors().getColor(containedStack, tintIndex);
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ModItems.VOID_TEAR.get()});
    }

    private static void registerPotionItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> ModItemColors.getColor(stack), new ItemLike[]{(ItemLike)ModItems.POTION_ESSENCE.get()});
        event.register((stack, tintIndex) -> {
            if (tintIndex == 1) {
                return ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).getColor();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ModItems.POTION.get(), (ItemLike)ModItems.SPLASH_POTION.get(), (ItemLike)ModItems.LINGERING_POTION.get()});
        event.register((stack, tintIndex) -> tintIndex == 0 ? ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).getColor() : -1, new ItemLike[]{(ItemLike)ModItems.TIPPED_ARROW.get()});
    }

    private static void registerBulletItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            if (tintIndex == 0) {
                return -1;
            }
            if (tintIndex == 1) {
                return ((BulletItem)stack.getItem()).getColor();
            }
            if (tintIndex == 2) {
                return ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).getColor();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ModItems.EMPTY_MAGAZINE.get(), (ItemLike)ModItems.NEUTRAL_MAGAZINE.get(), (ItemLike)ModItems.EXORCISM_MAGAZINE.get(), (ItemLike)ModItems.BLAZE_MAGAZINE.get(), (ItemLike)ModItems.ENDER_MAGAZINE.get(), (ItemLike)ModItems.CONCUSSIVE_MAGAZINE.get(), (ItemLike)ModItems.BUSTER_MAGAZINE.get(), (ItemLike)ModItems.SEEKER_MAGAZINE.get(), (ItemLike)ModItems.SAND_MAGAZINE.get(), (ItemLike)ModItems.STORM_MAGAZINE.get(), (ItemLike)ModItems.EMPTY_BULLET.get(), (ItemLike)ModItems.NEUTRAL_BULLET.get(), (ItemLike)ModItems.EXORCISM_BULLET.get(), (ItemLike)ModItems.BLAZE_BULLET.get(), (ItemLike)ModItems.ENDER_BULLET.get(), (ItemLike)ModItems.CONCUSSIVE_BULLET.get(), (ItemLike)ModItems.BUSTER_BULLET.get(), (ItemLike)ModItems.SEEKER_BULLET.get(), (ItemLike)ModItems.SAND_BULLET.get(), (ItemLike)ModItems.STORM_BULLET.get()});
    }

    private static void registerMobCharmItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            if (tintIndex < 1 || tintIndex > 2) {
                return -1;
            }
            ResourceLocation entityName = MobCharmItem.getEntityEggRegistryName(stack);
            return ModItemColors.getEgg(entityName).map(egg -> tintIndex == 1 ? FastColor.ARGB32.opaque((int)egg.getColor(0)) : FastColor.ARGB32.opaque((int)egg.getColor(1))).orElse(-1);
        }, new ItemLike[]{(ItemLike)ModItems.MOB_CHARM.get()});
        event.register((stack, tintIndex) -> {
            if (tintIndex < 0 || tintIndex > 1) {
                return -1;
            }
            ResourceLocation entityName = MobCharmFragmentItem.getEntityRegistryName(stack);
            return ModItemColors.getEgg(entityName).map(egg -> tintIndex == 0 ? FastColor.ARGB32.opaque((int)egg.getColor(0)) : FastColor.ARGB32.opaque((int)egg.getColor(1))).orElse(-1);
        }, new ItemLike[]{(ItemLike)ModItems.MOB_CHARM_FRAGMENT.get()});
    }

    private static Optional<SpawnEggItem> getEgg(ResourceLocation entityName) {
        return Optional.ofNullable(SpawnEggItem.byId((EntityType)((EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityName))));
    }

    private static int getColor(ItemStack stack) {
        return ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).getColor();
    }
}

