/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.misc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CreativeContentConstructor {
    private final List<CreativeContentData> entries = new ArrayList<CreativeContentData>();

    public void entry(CreativeModeTab tab, CreativeModeTab.TabVisibility visibility, ItemStack ... items) {
        this.entries.add(new CreativeContentData(tab, visibility, Arrays.asList(items)));
    }

    public void entry(CreativeModeTab tab, CreativeModeTab.TabVisibility visibility, ItemLike ... items) {
        this.entry(tab, visibility, (ItemStack[])Arrays.stream(items).map(ItemStack::new).toArray(ItemStack[]::new));
    }

    public List<CreativeContentData> getEntries() {
        return this.entries;
    }

    public static class CreativeContentData {
        private final CreativeModeTab tab;
        private final CreativeModeTab.TabVisibility visibility;
        private final List<ItemStack> stacks;

        public CreativeModeTab getTab() {
            return this.tab;
        }

        public CreativeModeTab.TabVisibility getVisibility() {
            return this.visibility;
        }

        public List<ItemStack> getStacks() {
            return this.stacks;
        }

        public CreativeContentData(CreativeModeTab tab, CreativeModeTab.TabVisibility visibility, List<ItemStack> stacks) {
            this.tab = tab;
            this.visibility = visibility;
            this.stacks = stacks;
        }
    }
}

