/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.octostudios.octolib.module.particle.trail.EntityTrailProvider;
import it.hurts.sskirillss.relics.entities.misc.ITargetableEntity;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.sync.S2CEntityTargetPacket;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class SporeEntity
extends ThrowableProjectile
implements ITargetableEntity {
    private static final EntityDataAccessor<ItemStack> RELIC_STACK = SynchedEntityData.defineId(SporeEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(SporeEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private LivingEntity target;

    public void setRelicStack(ItemStack stack) {
        this.getEntityData().set(RELIC_STACK, (Object)stack);
    }

    public ItemStack getRelicStack() {
        return (ItemStack)this.getEntityData().get(RELIC_STACK);
    }

    public void setDamage(float damage) {
        this.getEntityData().set(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.getEntityData().get(DAMAGE)).floatValue();
    }

    public SporeEntity(EntityType<? extends ThrowableProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        super.tick();
        Level level = this.getCommandSenderWorld();
        Vec3 particleCenter = this.position().add(this.getDeltaMovement().scale(-1.0));
        if (this.tickCount > 3) {
            for (int i = 0; i < 3; ++i) {
                level.addParticle(ParticleUtils.constructSimpleSpark(new Color(50 + this.random.nextInt(100), 150 + this.random.nextInt(100), 0), 0.01f + this.random.nextFloat() * Math.min((float)this.tickCount * 0.01f, 0.1f), 5 + this.random.nextInt(3), 0.9f), particleCenter.x() + (double)(MathUtils.randomFloat(this.random) * 0.05f), particleCenter.y() + (double)(MathUtils.randomFloat(this.random) * 0.05f), particleCenter.z() + (double)(MathUtils.randomFloat(this.random) * 0.05f), 0.0, 0.0, 0.0);
            }
        }
        if (this.tickCount >= 250) {
            if (!level.isClientSide()) {
                this.discard();
            }
            return;
        }
        if (this.target == null || this.target.isDeadOrDying()) {
            if (level.isClientSide()) {
                return;
            }
            List<LivingEntity> targets = this.locateNearestTargets();
            if (targets.isEmpty()) {
                return;
            }
            this.setTarget(targets.get(this.random.nextInt(targets.size())));
            NetworkHandler.sendToClientsTrackingEntity(new S2CEntityTargetPacket(this.getId(), this.target.getId()), (Entity)this);
            return;
        }
        Vec3 direction = this.target.position().subtract(this.position()).normalize();
        Vec3 motion = this.getDeltaMovement();
        float factor = Math.clamp((float)this.tickCount * 0.05f, 0.0f, 1.0f);
        this.setDeltaMovement(motion.x + (direction.x * (double)factor - motion.x) * (double)factor, motion.y, motion.z + (direction.z * (double)factor - motion.z) * (double)factor);
    }

    public List<LivingEntity> locateNearestTargets() {
        return EntityUtils.gatherPotentialTargets((Entity)this, LivingEntity.class, 32.0).filter(entity -> {
            Player player;
            Entity patt0$temp = this.getOwner();
            return !(patt0$temp instanceof Player) || !EntityUtils.isAlliedTo((Entity)(player = (Player)patt0$temp), (Entity)entity);
        }).toList();
    }

    public void onRemovedFromLevel() {
        super.onRemovedFromLevel();
        Level level = this.getCommandSenderWorld();
        Vec3 vec = this.position();
        level.playSound(null, this.blockPosition(), SoundEvents.PUFFER_FISH_BLOW_UP, SoundSource.MASTER, 0.5f, 1.5f + this.random.nextFloat() * 0.5f);
        for (int i = 0; i < 3; ++i) {
            ParticleUtils.createBall(ParticleUtils.constructSimpleSpark(new Color(50 + this.random.nextInt(100), 150 + this.random.nextInt(100), 0), 0.1f + this.random.nextFloat() * 0.2f, 20 + this.random.nextInt(10), 0.95f), vec, level, 1, 0.025f + this.random.nextFloat() * 0.15f);
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        Entity entity = this.getOwner();
        if (entity instanceof Player) {
            LivingEntity entity2;
            EntityHitResult entityResult;
            Player player = (Player)entity;
            if (result instanceof EntityHitResult && (entity = (entityResult = (EntityHitResult)result).getEntity()) instanceof LivingEntity && !(entity2 = (LivingEntity)entity).getStringUUID().equals(player.getStringUUID())) {
                entity2.invulnerableTime = 0;
                ItemStack stack = this.getRelicStack();
                if (entity2.hurt(this.getCommandSenderWorld().damageSources().thrown((Entity)this, (Entity)player), this.getDamage())) {
                    Item item = stack.getItem();
                    if (item instanceof IRelicItem) {
                        IRelicItem relic = (IRelicItem)item;
                        relic.spreadRelicExperience((LivingEntity)player, stack, 1);
                    }
                    if (this.isOnFire()) {
                        entity2.igniteForTicks(this.getRemainingFireTicks());
                    }
                    entity2.addEffect(new MobEffectInstance(EffectRegistry.ANTI_HEAL, 0, 100, false, false), (Entity)player);
                }
            }
        }
        this.discard();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(RELIC_STACK, (Object)ItemStack.EMPTY);
        builder.define(DAMAGE, (Object)Float.valueOf(1.0f));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("relic_stack", this.getRelicStack().save((HolderLookup.Provider)this.registryAccess()));
        tag.putFloat("damage", this.getDamage());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setRelicStack(ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)tag.getCompound("relic_stack")));
        this.setDamage(tag.getFloat("damage"));
    }

    public boolean isPushedByFluid() {
        return false;
    }

    @Override
    @Nullable
    public LivingEntity getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(LivingEntity target) {
        this.target = target;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TrailProvider
    extends EntityTrailProvider<SporeEntity> {
        public TrailProvider(SporeEntity entity) {
            super((Entity)entity);
        }

        public Vec3 getTrailPosition(float partialTicks) {
            return ((SporeEntity)this.entity).getPosition(partialTicks).add(((SporeEntity)this.entity).getDeltaMovement().scale(-1.0));
        }

        public int getTrailUpdateFrequency() {
            return 1;
        }

        public boolean isTrailAlive() {
            return ((SporeEntity)this.entity).isAlive();
        }

        public boolean isTrailGrowing() {
            return ((SporeEntity)this.entity).tickCount > 2;
        }

        public int getTrailMaxLength() {
            return 3;
        }

        public int getTrailFadeInColor() {
            return -11141376;
        }

        public int getTrailFadeOutColor() {
            return -2139029760;
        }

        public double getTrailScale() {
            return 0.075f;
        }
    }
}

