/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.renderer.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.models.entities.ShadowGlaiveModel;
import it.hurts.sskirillss.relics.entities.ShadowGlaiveEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShadowGlaiveRenderer
extends EntityRenderer<ShadowGlaiveEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/entities/shadow_glaive.png");

    public ShadowGlaiveRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(ShadowGlaiveEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        float time = (float)entity.tickCount + (Minecraft.getInstance().isPaused() ? 0.0f : partialTicks);
        matrixStackIn.pushPose();
        matrixStackIn.scale(1.35f, 1.35f, 1.35f);
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(time * 40.0f));
        matrixStackIn.translate(0.0f, -1.0f, -0.075f);
        new ShadowGlaiveModel().renderToBuffer(matrixStackIn, bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entity))), packedLightIn, OverlayTexture.NO_OVERLAY);
        matrixStackIn.popPose();
    }

    public ResourceLocation getTextureLocation(ShadowGlaiveEntity entity) {
        return TEXTURE;
    }
}

