/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.inventory;

import com.mrcrayfish.furniture.refurbished.blockentity.IPowerSwitch;
import com.mrcrayfish.furniture.refurbished.core.ModMenuTypes;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeBookTypes;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.crafting.OvenBakingRecipe;
import com.mrcrayfish.furniture.refurbished.inventory.IBakingMenu;
import com.mrcrayfish.furniture.refurbished.inventory.IContainerHolder;
import com.mrcrayfish.furniture.refurbished.inventory.IElectricityMenu;
import com.mrcrayfish.furniture.refurbished.inventory.IPowerSwitchMenu;
import com.mrcrayfish.furniture.refurbished.inventory.SimpleRecipeContainerMenu;
import com.mrcrayfish.furniture.refurbished.inventory.slot.ResultSlot;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public class StoveMenu
extends SimpleRecipeContainerMenu<SingleRecipeInput, OvenBakingRecipe>
implements IPowerSwitchMenu,
IElectricityMenu,
IContainerHolder,
IBakingMenu {
    private final ContainerData data;
    private final Level level;

    public StoveMenu(int windowId, Inventory playerInventory) {
        this(windowId, playerInventory, (Container)new SimpleContainer(6), (ContainerData)new SimpleContainerData(8));
    }

    public StoveMenu(int windowId, Inventory playerInventory, Container container, ContainerData data) {
        super((MenuType)ModMenuTypes.STOVE.get(), windowId, container);
        StoveMenu.checkContainerSize((Container)container, (int)6);
        StoveMenu.checkContainerDataCount((ContainerData)data, (int)8);
        container.startOpen(playerInventory.player);
        this.data = data;
        this.level = playerInventory.player.level();
        this.addContainerSlots(85, 18, 3, 1, 0);
        this.addContainerSlots(85, 54, 3, 1, 3, ResultSlot::new);
        this.addPlayerInventorySlots(8, 84, playerInventory);
        this.addDataSlots(data);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (slotIndex < this.container.getContainerSize() ? !this.moveItemStackTo(slotStack, this.container.getContainerSize(), this.slots.size(), true) : (this.isRecipe(slotStack) ? !this.moveItemStackTo(slotStack, 0, 3, false) : (slotIndex < this.container.getContainerSize() + 27 ? !this.moveItemStackTo(slotStack, this.container.getContainerSize() + 27, this.slots.size(), false) : !this.moveItemStackTo(slotStack, this.container.getContainerSize(), this.slots.size() - 9, false)))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return stack;
    }

    private boolean isRecipe(ItemStack stack) {
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.OVEN_BAKING.get(), (RecipeInput)new SingleRecipeInput(stack), this.level).isPresent();
    }

    @Override
    public int getBakingProgress(int index) {
        return switch (index) {
            case 0 -> this.data.get(2);
            case 1 -> this.data.get(3);
            case 2 -> this.data.get(4);
            default -> 0;
        };
    }

    @Override
    public int getTotalBakingProgress(int index) {
        return switch (index) {
            case 0 -> this.data.get(5);
            case 1 -> this.data.get(6);
            case 2 -> this.data.get(7);
            default -> 0;
        };
    }

    @Override
    public boolean isPowered() {
        return this.data.get(0) != 0;
    }

    @Override
    public boolean isEnabled() {
        return this.data.get(1) != 0;
    }

    @Override
    public void toggle() {
        Container container = this.container;
        if (container instanceof IPowerSwitch) {
            IPowerSwitch powerSwitch = (IPowerSwitch)container;
            powerSwitch.togglePower();
        }
    }

    public void fillCraftSlotsStackedContents(StackedContents contents) {
        if (this.container instanceof StackedContentsCompatible) {
            ((StackedContentsCompatible)this.container).fillStackedContents(contents);
        }
    }

    public void clearCraftingContent() {
        this.getSlot(0).set(ItemStack.EMPTY);
        this.getSlot(3).set(ItemStack.EMPTY);
    }

    public boolean recipeMatches(RecipeHolder<OvenBakingRecipe> holder) {
        return ((OvenBakingRecipe)holder.value()).matches(new SingleRecipeInput(this.container.getItem(0)), this.level);
    }

    public int getResultSlotIndex() {
        return 3;
    }

    public int getGridWidth() {
        return 1;
    }

    public int getGridHeight() {
        return 1;
    }

    public int getSize() {
        return 6;
    }

    public RecipeBookType getRecipeBookType() {
        return ModRecipeBookTypes.OVEN.get();
    }

    public boolean shouldMoveToInventory(int slot) {
        return slot == 0 || slot == 3;
    }

    @Override
    public Container container() {
        return this.container;
    }
}

