/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.entity.vulture;

import com.mojang.serialization.Dynamic;
import it.hurts.shatterbyte.reanimal.common.entity.vulture.VultureAI;
import it.hurts.shatterbyte.reanimal.init.ReAnimalEntities;
import it.hurts.shatterbyte.reanimal.init.ReAnimalItems;
import it.hurts.shatterbyte.reanimal.init.ReAnimalSoundEvents;
import it.hurts.shatterbyte.reanimal.init.ReAnimalTags;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VultureEntity
extends Animal
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> DATA_GLIDING = SynchedEntityData.defineId(VultureEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.vulture.idle");
    private static final RawAnimation FLY = RawAnimation.begin().thenLoop("animation.vulture.fly");
    private static final RawAnimation GLIDING = RawAnimation.begin().thenLoop("animation.vulture.gliding");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.vulture.walk");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private LivingEntity circlingTarget;
    private float circlingAngle;
    private long circlingStartTick;
    private int eggTime = this.random.nextInt(6000) + 6000;
    private long nextCirclingStartTick;

    public void setNextCirclingStartTick(long gameTime, long cooldownTicks) {
        this.nextCirclingStartTick = gameTime + cooldownTicks;
    }

    public boolean canStartCircling(long gameTime) {
        return gameTime >= this.nextCirclingStartTick;
    }

    public boolean isGliding() {
        return (Boolean)this.entityData.get(DATA_GLIDING);
    }

    public void setGliding(boolean gliding) {
        this.entityData.set(DATA_GLIDING, (Object)gliding);
    }

    public VultureEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.lookControl = new VultureLookControl(this);
        this.updateMoveControl();
        this.getNavigation().setCanFloat(true);
    }

    public void aiStep() {
        super.aiStep();
        this.tickEggLaying();
    }

    protected void customServerAiStep() {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            super.customServerAiStep();
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ProfilerFiller profiler = level.getProfiler();
        profiler.push("vultureBrain");
        this.getBrain().tick(serverLevel, (LivingEntity)this);
        profiler.pop();
        profiler.push("vultureActivityUpdate");
        VultureAI.updateActivity(this);
        profiler.pop();
        this.tickCircling();
        super.customServerAiStep();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_GLIDING, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.updateMoveControl();
    }

    public void setBaby(boolean baby) {
        super.setBaby(baby);
        this.updateMoveControl();
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
        this.resetFallDistance();
    }

    protected Brain.Provider<VultureEntity> brainProvider() {
        return VultureAI.brainProvider();
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return VultureAI.makeBrain((Brain<VultureEntity>)this.brainProvider().makeBrain(dynamic));
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ReAnimalTags.Items.VULTURE_FOOD);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ReAnimalSoundEvents.VULTURE_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ReAnimalSoundEvents.VULTURE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ReAnimalSoundEvents.VULTURE_DEATH.get();
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob partner) {
        VultureEntity baby = (VultureEntity)((EntityType)ReAnimalEntities.VULTURE.get()).create((Level)level);
        if (baby != null) {
            baby.setBaby(true);
        }
        return baby;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "main", 5, this::mainPredicate));
    }

    public void updateMoveControl() {
        if (this.isBaby()) {
            this.moveControl = new MoveControl((Mob)this);
            this.navigation = new GroundPathNavigation((Mob)this, this.level());
        } else {
            this.moveControl = new FlyingMoveControl((Mob)this, 10, false);
            this.navigation = new FlyingPathNavigation((Mob)this, this.level());
        }
    }

    private void tickEggLaying() {
        if (this.level().isClientSide() || this.isBaby()) {
            return;
        }
        if (--this.eggTime > 0) {
            return;
        }
        this.playSound(SoundEvents.CHICKEN_EGG, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        this.spawnAtLocation((ItemLike)ReAnimalItems.VULTURE_EGG.get());
        this.gameEvent((Holder)GameEvent.ENTITY_PLACE, (Entity)this);
        this.eggTime = this.random.nextInt(6000) + 6000;
    }

    private void tickCircling() {
        LivingEntity target = this.circlingTarget;
        if (target == null || !target.isAlive()) {
            this.circlingTarget = null;
            this.setGliding(false);
            return;
        }
        if (this.getTarget() != null) {
            this.circlingTarget = null;
            this.setGliding(false);
            return;
        }
        if (this.distanceToSqr((Entity)target) > 4096.0) {
            this.circlingTarget = null;
            this.setGliding(false);
            return;
        }
        this.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        double radius = 5.0;
        double height = 12.0;
        float angleSpeed = 0.08f;
        Vec3 targetPos = target.position();
        double centerX = targetPos.x;
        double centerY = targetPos.y + (double)target.getBbHeight() + height;
        double centerZ = targetPos.z;
        double orbitX = centerX + radius * Math.cos(this.circlingAngle);
        double orbitZ = centerZ + radius * Math.sin(this.circlingAngle);
        double orbitY = centerY;
        Vec3 oldPos = this.position();
        Vec3 orbitPos = new Vec3(orbitX, orbitY, orbitZ);
        Vec3 toOrbit = orbitPos.subtract(oldPos);
        double threshold = 2.5;
        if (toOrbit.lengthSqr() > threshold * threshold) {
            this.getNavigation().moveTo(orbitX, orbitY, orbitZ, 1.15);
            return;
        }
        this.getNavigation().stop();
        this.circlingAngle += angleSpeed;
        orbitX = centerX + radius * Math.cos(this.circlingAngle);
        orbitZ = centerZ + radius * Math.sin(this.circlingAngle);
        orbitY = centerY;
        Vec3 nextPos = new Vec3(orbitX, orbitY, orbitZ);
        Vec3 move = nextPos.subtract(oldPos);
        double maxStep = 0.6;
        double moveLenSq = move.lengthSqr();
        if (moveLenSq > maxStep * maxStep && moveLenSq > 1.0E-4) {
            move = move.normalize().scale(maxStep);
        }
        this.setDeltaMovement(move);
        Vec3 delta = this.getDeltaMovement();
        if (delta.lengthSqr() > 1.0E-4) {
            double yawRad = Math.atan2(delta.z, delta.x);
            float yawDeg = (float)(yawRad * 180.0 / Math.PI) - 90.0f;
            this.setYRot(yawDeg);
            this.yRotO = yawDeg;
            this.yBodyRot = yawDeg;
            this.yBodyRotO = yawDeg;
            this.setYHeadRot(yawDeg);
            this.yHeadRotO = yawDeg;
            this.setXRot(0.0f);
            this.xRotO = 0.0f;
        }
        this.setGliding(true);
    }

    private PlayState mainPredicate(AnimationState<VultureEntity> state) {
        AnimationController controller = state.getController();
        VultureEntity entity = (VultureEntity)state.getAnimatable();
        if (state.isMoving()) {
            if (entity.onGround()) {
                controller.setAnimation(WALK);
            } else if (entity.isGliding()) {
                controller.setAnimation(GLIDING);
            } else {
                controller.setAnimation(FLY);
            }
        } else {
            controller.setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public static boolean checkVultureSpawnRules(EntityType<VultureEntity> type, ServerLevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return Animal.checkAnimalSpawnRules(type, (LevelAccessor)level, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FLYING_SPEED, 0.35).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    @Generated
    public LivingEntity getCirclingTarget() {
        return this.circlingTarget;
    }

    @Generated
    public void setCirclingTarget(LivingEntity circlingTarget) {
        this.circlingTarget = circlingTarget;
    }

    @Generated
    public void setCirclingAngle(float circlingAngle) {
        this.circlingAngle = circlingAngle;
    }

    @Generated
    public long getCirclingStartTick() {
        return this.circlingStartTick;
    }

    @Generated
    public void setCirclingStartTick(long circlingStartTick) {
        this.circlingStartTick = circlingStartTick;
    }

    private static class VultureLookControl
    extends LookControl {
        private final VultureEntity vulture;

        VultureLookControl(VultureEntity vulture) {
            super((Mob)vulture);
            this.vulture = vulture;
        }

        public void tick() {
            double lookZ;
            double lookY;
            double lookX;
            LivingEntity living;
            LivingEntity rawTarget;
            LivingEntity attackTarget;
            VultureEntity mob = this.vulture;
            float maxYaw = 10.0f;
            float maxPitch = 20.0f;
            float yRot = mob.getYRot();
            float xRot = mob.getXRot();
            LivingEntity circlingTarget = mob.getCirclingTarget();
            if (circlingTarget != null && !circlingTarget.isAlive()) {
                mob.setCirclingTarget(null);
                circlingTarget = null;
            }
            LivingEntity livingEntity = attackTarget = (rawTarget = mob.getTarget()) instanceof LivingEntity && (living = rawTarget).isAlive() ? living : null;
            if (circlingTarget != null && attackTarget == null) {
                Vec3 pos = circlingTarget.position();
                lookX = pos.x;
                lookY = pos.y + (double)circlingTarget.getBbHeight() + 6.0;
                lookZ = pos.z;
            } else if (attackTarget != null) {
                lookX = attackTarget.getX();
                lookY = attackTarget.getEyeY();
                lookZ = attackTarget.getZ();
            } else {
                if (mob.onGround()) {
                    super.tick();
                    return;
                }
                Vec3 delta = mob.getDeltaMovement();
                if (delta.lengthSqr() <= 1.0E-4) {
                    super.tick();
                    return;
                }
                double dx = delta.x;
                double dz = delta.z;
                double horiz = Math.sqrt(dx * dx + dz * dz);
                if (horiz <= 1.0E-4) {
                    super.tick();
                    return;
                }
                float yaw = (float)(Mth.atan2((double)dz, (double)dx) * 180.0 / Math.PI) - 90.0f;
                float pitch = (float)(-(Mth.atan2((double)delta.y, (double)horiz) * 180.0 / Math.PI));
                yRot = this.rotateTowards(yRot, yaw, maxYaw);
                xRot = this.rotateTowards(xRot, pitch, maxPitch);
                mob.setYRot(yRot);
                mob.yBodyRot = yRot;
                mob.setYHeadRot(yRot);
                mob.setXRot(xRot);
                return;
            }
            double dx = lookX - mob.getX();
            double dy = lookY - mob.getEyeY();
            double dz = lookZ - mob.getZ();
            double distSq = dx * dx + dz * dz;
            if (distSq > 1.0E-5 || Math.abs(dy) > 0.001) {
                float yaw = (float)(Mth.atan2((double)dz, (double)dx) * 180.0 / Math.PI) - 90.0f;
                float pitch = (float)(-(Mth.atan2((double)dy, (double)Math.sqrt(distSq)) * 180.0 / Math.PI));
                yRot = this.rotateTowards(yRot, yaw, maxYaw);
                xRot = this.rotateTowards(xRot, pitch, maxPitch);
                mob.setYRot(yRot);
                mob.yBodyRot = yRot;
                mob.setYHeadRot(yRot);
                mob.setXRot(xRot);
            }
        }

        public float rotateTowards(float current, float target, float maxChange) {
            float diff = Mth.degreesDifference((float)current, (float)target);
            if (diff > maxChange) {
                diff = maxChange;
            }
            if (diff < -maxChange) {
                diff = -maxChange;
            }
            return current + diff;
        }
    }

    private static class VultureMoveControl
    extends FlyingMoveControl {
        private final VultureEntity mob;

        VultureMoveControl(VultureEntity mob) {
            super((Mob)mob, 15, false);
            this.mob = mob;
        }

        public void tick() {
            double dz;
            double dy;
            if (this.operation != MoveControl.Operation.MOVE_TO) {
                Vec3 delta = this.mob.getDeltaMovement();
                this.mob.setDeltaMovement(delta.scale(0.9));
                return;
            }
            this.operation = MoveControl.Operation.WAIT;
            double dx = this.wantedX - this.mob.getX();
            double distSq = dx * dx + (dy = this.wantedY - this.mob.getY()) * dy + (dz = this.wantedZ - this.mob.getZ()) * dz;
            if (distSq < 1.0E-4) {
                return;
            }
            double dist = Math.sqrt(distSq);
            double baseSpeed = this.mob.getAttributeValue(Attributes.FLYING_SPEED);
            double accel = 0.3;
            double vyBoost = 0.15;
            double vx = dx / dist * baseSpeed;
            double vy = dy / dist * baseSpeed + vyBoost;
            double vz = dz / dist * baseSpeed;
            Vec3 current = this.mob.getDeltaMovement();
            this.mob.setDeltaMovement(Mth.lerp((double)accel, (double)current.x, (double)vx), Mth.lerp((double)accel, (double)current.y, (double)vy), Mth.lerp((double)accel, (double)current.z, (double)vz));
        }
    }
}

