/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.entity.vulture;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import it.hurts.shatterbyte.reanimal.common.entity.vulture.VultureEntity;
import it.hurts.shatterbyte.reanimal.init.ReAnimalEntities;
import it.hurts.shatterbyte.reanimal.init.ReAnimalSensorTypes;
import it.hurts.shatterbyte.reanimal.init.ReAnimalTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class VultureAI {
    private static final ImmutableList<SensorType<? extends Sensor<? super VultureEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, (Object)((SensorType)ReAnimalSensorTypes.VULTURE_TEMPTATIONS.get()), (Object)SensorType.NEAREST_ADULT);
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.IS_PANICKING, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, (Object)MemoryModuleType.GAZE_COOLDOWN_TICKS, (Object)MemoryModuleType.IS_TEMPTED, (Object[])new MemoryModuleType[]{MemoryModuleType.BREED_TARGET, MemoryModuleType.NEAREST_VISIBLE_ADULT, MemoryModuleType.DANGER_DETECTED_RECENTLY});

    public static Brain.Provider<VultureEntity> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<?> makeBrain(Brain<VultureEntity> brain) {
        VultureAI.initCoreActivity(brain);
        VultureAI.initIdleActivity(brain);
        brain.setCoreActivities(Set.of(Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<VultureEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.GAZE_COOLDOWN_TICKS)));
    }

    private static void initIdleActivity(Brain<VultureEntity> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)8.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new AnimalMakeLove((EntityType)ReAnimalEntities.VULTURE.get(), 1.0f, 1)), (Object)Pair.of((Object)2, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new FollowTemptation(e -> Float.valueOf(1.2f), e -> 1.2), (Object)1), (Object)Pair.of((Object)BabyFollowAdult.create((UniformInt)UniformInt.of((int)2, (int)4), (float)1.1f), (Object)1)))), (Object)Pair.of((Object)3, (Object)((Object)new VultureRetaliateTask())), (Object)Pair.of((Object)4, (Object)((Object)new VultureStartCirclingTask())), (Object)Pair.of((Object)5, (Object)((Object)new VultureAttackFromCircleTask())), (Object)Pair.of((Object)6, (Object)((Object)new VultureChaseAndAttackTask())), (Object)Pair.of((Object)7, (Object)((Object)new VultureStopCirclingTask())), (Object)Pair.of((Object)8, (Object)((Object)new VultureEatGroundMeatTask())), (Object)Pair.of((Object)9, (Object)new RandomLookAround((IntProvider)UniformInt.of((int)150, (int)250), 30.0f, 0.0f, 0.0f)), (Object)Pair.of((Object)10, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)1.1f), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.1f, (int)3), (Object)1), (Object)Pair.of((Object)new DoNothing(80, 160), (Object)6))))));
    }

    public static void updateActivity(VultureEntity entity) {
        entity.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.IDLE));
    }

    public static Predicate<ItemStack> getTemptations() {
        return stack -> stack.is(ReAnimalTags.Items.VULTURE_FOOD);
    }

    static class VultureRetaliateTask
    extends Behavior<VultureEntity> {
        VultureRetaliateTask() {
            super((Map)ImmutableMap.of((Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryStatus.VALUE_PRESENT));
        }

        protected boolean checkExtraStartConditions(ServerLevel level, VultureEntity entity) {
            Player player;
            Optional optional = entity.getBrain().getMemory(MemoryModuleType.HURT_BY_ENTITY);
            if (optional.isEmpty()) {
                return false;
            }
            LivingEntity attacker = (LivingEntity)optional.get();
            if (!(attacker instanceof LivingEntity)) {
                return false;
            }
            LivingEntity living = attacker;
            if (!living.isAlive()) {
                return false;
            }
            if (living.isInvulnerable()) {
                return false;
            }
            if (living instanceof Player && ((player = (Player)living).isCreative() || player.isSpectator())) {
                return false;
            }
            return entity.distanceToSqr((Entity)living) <= 4096.0;
        }

        protected void start(ServerLevel level, VultureEntity entity, long gameTime) {
            Player player;
            Optional optional = entity.getBrain().getMemory(MemoryModuleType.HURT_BY_ENTITY);
            if (optional.isEmpty()) {
                return;
            }
            LivingEntity attacker = (LivingEntity)optional.get();
            if (!attacker.isAlive()) {
                return;
            }
            if (attacker.isInvulnerable()) {
                return;
            }
            if (attacker instanceof Player && ((player = (Player)attacker).isCreative() || player.isSpectator())) {
                return;
            }
            entity.setCirclingTarget(null);
            entity.setNextCirclingStartTick(level.getGameTime(), 500L);
            entity.setTarget(attacker);
            entity.getBrain().eraseMemory(MemoryModuleType.HURT_BY_ENTITY);
            entity.getBrain().eraseMemory(MemoryModuleType.HURT_BY);
        }
    }

    static class VultureStartCirclingTask
    extends Behavior<VultureEntity> {
        VultureStartCirclingTask() {
            super((Map)ImmutableMap.of((Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT));
        }

        protected boolean checkExtraStartConditions(ServerLevel level, VultureEntity entity) {
            if (entity.getCirclingTarget() != null) {
                return false;
            }
            if (entity.getTarget() != null) {
                return false;
            }
            if (!entity.getNavigation().isDone()) {
                return false;
            }
            if (entity.getBrain().getMemory(MemoryModuleType.HURT_BY_ENTITY).isPresent()) {
                return false;
            }
            Optional optional = entity.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
            if (optional.isEmpty()) {
                return false;
            }
            long gameTime = level.getGameTime();
            if (!entity.canStartCircling(gameTime)) {
                return false;
            }
            if (gameTime % 20L != 0L) {
                return false;
            }
            NearestVisibleLivingEntities visible = (NearestVisibleLivingEntities)optional.get();
            Iterable list = visible.findAll(e -> true);
            ArrayList<LivingEntity> candidates = new ArrayList<LivingEntity>();
            double radiusSq = 256.0;
            for (LivingEntity candidate : list) {
                Player player;
                LivingEntity living;
                if (!(candidate instanceof LivingEntity) || !(living = candidate).isAlive() || living.isInvulnerable() || living.isInWaterOrBubble() || living instanceof VultureEntity || living instanceof Player && ((player = (Player)living).isCreative() || player.isSpectator()) || !(living.getHealth() < living.getMaxHealth()) || !(entity.distanceToSqr((Entity)living) <= radiusSq)) continue;
                candidates.add(living);
            }
            return !candidates.isEmpty();
        }

        protected void start(ServerLevel level, VultureEntity entity, long gameTime) {
            Optional optional = entity.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
            if (optional.isEmpty()) {
                return;
            }
            NearestVisibleLivingEntities visible = (NearestVisibleLivingEntities)optional.get();
            Iterable list = visible.findAll(e -> true);
            ArrayList<LivingEntity> candidates = new ArrayList<LivingEntity>();
            double radiusSq = 256.0;
            for (LivingEntity candidate : list) {
                Player player;
                LivingEntity living;
                if (!(candidate instanceof LivingEntity) || !(living = candidate).isAlive() || living.isInvulnerable() || living instanceof VultureEntity || living instanceof Player && ((player = (Player)living).isCreative() || player.isSpectator()) || !(living.getHealth() < living.getMaxHealth()) || !(entity.distanceToSqr((Entity)living) <= radiusSq)) continue;
                candidates.add(living);
            }
            if (candidates.isEmpty()) {
                return;
            }
            candidates.sort((a, b) -> {
                double da = entity.distanceToSqr((Entity)a);
                double db = entity.distanceToSqr((Entity)b);
                return Double.compare(da, db);
            });
            RandomSource random = entity.getRandom();
            for (LivingEntity living : candidates) {
                float healthRatio;
                float maxHealth = living.getMaxHealth();
                if (maxHealth <= 0.0f || (healthRatio = living.getHealth() / maxHealth) >= 1.0f) continue;
                float attachChance = 1.0f - healthRatio;
                attachChance = Mth.clamp((float)attachChance, (float)0.0f, (float)1.0f);
                if (!(random.nextFloat() < attachChance)) continue;
                entity.setCirclingTarget(living);
                entity.setCirclingAngle(random.nextFloat() * ((float)Math.PI * 2));
                entity.setCirclingStartTick(level.getGameTime());
                return;
            }
        }
    }

    static class VultureAttackFromCircleTask
    extends Behavior<VultureEntity> {
        private static final long MIN_CIRCLING_TICKS = 200L;
        private static final long MAX_NON_PLAYER_CIRCLING_TICKS = 600L;

        VultureAttackFromCircleTask() {
            super((Map)ImmutableMap.of());
        }

        protected boolean checkExtraStartConditions(ServerLevel level, VultureEntity entity) {
            long startTime;
            Player player;
            LivingEntity circlingTarget = entity.getCirclingTarget();
            if (circlingTarget == null) {
                return false;
            }
            if (!circlingTarget.isAlive()) {
                return false;
            }
            if (circlingTarget.isInvulnerable()) {
                return false;
            }
            if (circlingTarget.isInWaterOrBubble()) {
                return false;
            }
            if (circlingTarget instanceof VultureEntity) {
                return false;
            }
            if (circlingTarget instanceof Player && ((player = (Player)circlingTarget).isCreative() || player.isSpectator())) {
                return false;
            }
            long currentTime = level.getGameTime();
            long elapsed = currentTime - (startTime = entity.getCirclingStartTick());
            if (elapsed < 200L) {
                return false;
            }
            if ((elapsed - 200L) % 20L != 0L) {
                return false;
            }
            Optional optional = entity.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
            Boolean visible = optional.map(list -> list.contains(circlingTarget)).orElse(false);
            if (!visible.booleanValue()) {
                return false;
            }
            if (!(circlingTarget instanceof Player) && elapsed >= 600L) {
                return false;
            }
            float maxHealth = circlingTarget.getMaxHealth();
            if (maxHealth <= 0.0f) {
                return false;
            }
            float healthRatio = circlingTarget.getHealth() / maxHealth;
            if (healthRatio >= 1.0f) {
                return false;
            }
            if (healthRatio > 0.5f) {
                return false;
            }
            float attackChance = 0.5f - healthRatio;
            return entity.getRandom().nextFloat() < attackChance;
        }

        protected void start(ServerLevel level, VultureEntity entity, long gameTime) {
            LivingEntity circlingTarget = entity.getCirclingTarget();
            if (circlingTarget == null) {
                return;
            }
            entity.setCirclingTarget(null);
            entity.setNextCirclingStartTick(level.getGameTime(), 500L);
            entity.setTarget(circlingTarget);
        }
    }

    static class VultureChaseAndAttackTask
    extends Behavior<VultureEntity> {
        VultureChaseAndAttackTask() {
            super((Map)ImmutableMap.of());
        }

        protected boolean checkExtraStartConditions(ServerLevel level, VultureEntity entity) {
            Player player;
            LivingEntity target = entity.getTarget();
            if (!(target instanceof LivingEntity)) {
                return false;
            }
            LivingEntity living = target;
            if (!living.isAlive()) {
                return false;
            }
            if (living.isInvulnerable()) {
                return false;
            }
            if (living.isInWaterOrBubble()) {
                return false;
            }
            if (living instanceof VultureEntity) {
                return false;
            }
            if (living instanceof Player && ((player = (Player)living).isCreative() || player.isSpectator())) {
                return false;
            }
            return entity.distanceToSqr((Entity)living) <= 4096.0;
        }

        protected boolean canStillUse(ServerLevel level, VultureEntity entity, long gameTime) {
            Player player;
            LivingEntity target = entity.getTarget();
            if (!(target instanceof LivingEntity)) {
                return false;
            }
            LivingEntity living = target;
            if (!living.isAlive()) {
                return false;
            }
            if (living.isInvulnerable()) {
                return false;
            }
            if (living.isInWaterOrBubble()) {
                return false;
            }
            if (living instanceof VultureEntity) {
                return false;
            }
            if (living instanceof Player && ((player = (Player)living).isCreative() || player.isSpectator())) {
                return false;
            }
            return entity.distanceToSqr((Entity)living) <= 4096.0;
        }

        protected void tick(ServerLevel level, VultureEntity entity, long gameTime) {
            Player player;
            LivingEntity target = entity.getTarget();
            if (!(target instanceof LivingEntity)) {
                entity.setTarget(null);
                entity.getNavigation().stop();
                return;
            }
            LivingEntity living = target;
            if (!living.isAlive() || living.isInvulnerable() || living.isInWaterOrBubble() || living instanceof VultureEntity || living instanceof Player && ((player = (Player)living).isCreative() || player.isSpectator()) || entity.distanceToSqr((Entity)living) > 4096.0) {
                entity.setTarget(null);
                entity.getNavigation().stop();
                return;
            }
            entity.getNavigation().moveTo((Entity)living, 1.4);
            double distanceSqr = entity.distanceToSqr((Entity)living);
            if (distanceSqr <= 4.0 && gameTime % 20L == 0L) {
                entity.doHurtTarget((Entity)living);
            }
        }

        protected void stop(ServerLevel level, VultureEntity entity, long gameTime) {
            LivingEntity target = entity.getTarget();
            if (target instanceof LivingEntity) {
                Player player;
                LivingEntity living = target;
                if (!living.isAlive() || living.isInvulnerable() || living.isInWaterOrBubble() || living instanceof VultureEntity || living instanceof Player && ((player = (Player)living).isCreative() || player.isSpectator()) || entity.distanceToSqr((Entity)living) > 4096.0) {
                    entity.setTarget(null);
                }
            } else {
                entity.setTarget(null);
            }
            entity.getNavigation().stop();
        }
    }

    static class VultureStopCirclingTask
    extends Behavior<VultureEntity> {
        private static final long MAX_NON_PLAYER_CIRCLING_TICKS = 600L;

        VultureStopCirclingTask() {
            super((Map)ImmutableMap.of());
        }

        protected boolean checkExtraStartConditions(ServerLevel level, VultureEntity entity) {
            long elapsed;
            LivingEntity target = entity.getCirclingTarget();
            if (target == null) {
                return false;
            }
            if (!target.isAlive()) {
                return true;
            }
            Optional optional = entity.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
            Boolean visible = optional.map(list -> list.contains(target)).orElse(false);
            if (!visible.booleanValue()) {
                return true;
            }
            if (!(target instanceof Player) && (elapsed = level.getGameTime() - entity.getCirclingStartTick()) >= 600L) {
                return true;
            }
            return target.getHealth() >= target.getMaxHealth();
        }

        protected void start(ServerLevel level, VultureEntity entity, long gameTime) {
            entity.setCirclingTarget(null);
            entity.setNextCirclingStartTick(level.getGameTime(), 500L);
            BlockPos pos = entity.blockPosition();
            BlockPos groundPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos);
            entity.getNavigation().moveTo((double)groundPos.getX() + 0.5, (double)groundPos.getY(), (double)groundPos.getZ() + 0.5, 1.0);
            entity.setDeltaMovement(Vec3.ZERO);
        }
    }

    static class VultureEatGroundMeatTask
    extends Behavior<VultureEntity> {
        private static final double SEARCH_RADIUS = 16.0;
        private ItemEntity targetItem;

        VultureEatGroundMeatTask() {
            super((Map)ImmutableMap.of());
        }

        protected boolean checkExtraStartConditions(ServerLevel level, VultureEntity entity) {
            if (entity.getTarget() != null) {
                return false;
            }
            if (entity.getCirclingTarget() != null) {
                return false;
            }
            if (!entity.getNavigation().isDone()) {
                return false;
            }
            AABB box = entity.getBoundingBox().inflate(16.0);
            List list = level.getEntitiesOfClass(ItemEntity.class, box, item -> {
                ItemStack stack = item.getItem();
                return !item.isRemoved() && stack.is(ReAnimalTags.Items.VULTURE_FOOD);
            });
            if (list.isEmpty()) {
                return false;
            }
            list.sort((a, b) -> {
                double da = entity.distanceToSqr((Entity)a);
                double db = entity.distanceToSqr((Entity)b);
                return Double.compare(da, db);
            });
            this.targetItem = (ItemEntity)list.getFirst();
            return true;
        }

        protected boolean canStillUse(ServerLevel level, VultureEntity entity, long gameTime) {
            if (this.targetItem == null || this.targetItem.isRemoved()) {
                return false;
            }
            if (entity.getTarget() != null) {
                return false;
            }
            if (entity.getCirclingTarget() != null) {
                return false;
            }
            double maxDistSqr = 256.0;
            return !(entity.distanceToSqr((Entity)this.targetItem) > maxDistSqr);
        }

        protected void start(ServerLevel level, VultureEntity entity, long gameTime) {
            if (this.targetItem == null || this.targetItem.isRemoved()) {
                return;
            }
            entity.getNavigation().moveTo((Entity)this.targetItem, 1.2);
        }

        protected void tick(ServerLevel level, VultureEntity entity, long gameTime) {
            if (this.targetItem == null || this.targetItem.isRemoved()) {
                entity.getNavigation().stop();
                return;
            }
            entity.getNavigation().moveTo((Entity)this.targetItem, 1.2);
            double distanceSqr = entity.distanceToSqr((Entity)this.targetItem);
            if (distanceSqr <= 2.0) {
                ItemStack stack = this.targetItem.getItem();
                if (!stack.isEmpty() && stack.is(ReAnimalTags.Items.VULTURE_FOOD)) {
                    stack.shrink(1);
                    if (stack.isEmpty()) {
                        this.targetItem.discard();
                    }
                }
                entity.getNavigation().stop();
                this.targetItem = null;
            }
        }

        protected void stop(ServerLevel level, VultureEntity entity, long gameTime) {
            entity.getNavigation().stop();
            this.targetItem = null;
        }
    }
}

