/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.entity.seal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import it.hurts.shatterbyte.reanimal.common.entity.seal.SealEntity;
import it.hurts.shatterbyte.reanimal.init.ReAnimalEntities;
import it.hurts.shatterbyte.reanimal.init.ReAnimalSensorTypes;
import it.hurts.shatterbyte.reanimal.init.ReAnimalTags;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class SealAI {
    private static final ImmutableList<SensorType<? extends Sensor<? super SealEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, (Object)((SensorType)ReAnimalSensorTypes.SEAL_TEMPTATIONS.get()), (Object)SensorType.NEAREST_ADULT);
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.IS_PANICKING, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, (Object)MemoryModuleType.GAZE_COOLDOWN_TICKS, (Object)MemoryModuleType.IS_TEMPTED, (Object[])new MemoryModuleType[]{MemoryModuleType.BREED_TARGET, MemoryModuleType.NEAREST_VISIBLE_ADULT, MemoryModuleType.DANGER_DETECTED_RECENTLY, MemoryModuleType.ATTACK_TARGET});

    public static Brain.Provider<SealEntity> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<?> makeBrain(Brain<SealEntity> brain) {
        SealAI.initCoreActivity(brain);
        SealAI.initIdleActivity(brain);
        SealAI.initPanicActivity(brain);
        brain.setCoreActivities(Set.of(Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<SealEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)((Object)new LayCooldownBehavior()), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.GAZE_COOLDOWN_TICKS)));
    }

    private static void initIdleActivity(Brain<SealEntity> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new LayBehavior())), (Object)Pair.of((Object)1, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)2, (Object)new AnimalMakeLove((EntityType)ReAnimalEntities.SEAL.get(), 1.0f, 1)), (Object)Pair.of((Object)3, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new FollowTemptation(entity -> Float.valueOf(1.25f), entity -> entity.isBaby() ? 1.0 : 2.0), (Object)1), (Object)Pair.of((Object)BabyFollowAdult.create((UniformInt)UniformInt.of((int)3, (int)6), (float)1.25f), (Object)1)))), (Object)Pair.of((Object)4, (Object)((Object)new SealHuntFish(1.4f, 16.0))), (Object)Pair.of((Object)5, (Object)new RandomLookAround((IntProvider)UniformInt.of((int)150, (int)250), 30.0f, 0.0f, 0.0f)), (Object)Pair.of((Object)6, (Object)((Object)new SealMoveToEnvironmentTarget(1.2f))), (Object)Pair.of((Object)7, (Object)((Object)new SealSwitchEnvironment(16, 0.1f))), (Object)Pair.of((Object)8, (Object)new RunOne((Map)ImmutableMap.of(), (List)ImmutableList.of((Object)Pair.of((Object)((Object)new SealSwim(1.2f)), (Object)1), (Object)Pair.of((Object)((Object)new SealLandStroll(1.0f, 50, 100, 100, 200)), (Object)1))))));
    }

    private static void initPanicActivity(Brain<SealEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.PANIC, 10, ImmutableList.of((Object)new AnimalPanic(1.5f, mob -> DamageTypeTags.PANIC_CAUSES)), MemoryModuleType.IS_PANICKING);
    }

    public static void updateActivity(SealEntity entity) {
        entity.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.PANIC, (Object)Activity.IDLE));
    }

    public static Predicate<ItemStack> getTemptations() {
        return stack -> stack.is(ReAnimalTags.Items.SEAL_FOOD);
    }

    public static class LayCooldownBehavior
    extends Behavior<SealEntity> {
        public LayCooldownBehavior() {
            super((Map)ImmutableMap.of(), 1200);
        }

        protected boolean canStillUse(ServerLevel level, SealEntity entity, long gameTime) {
            return true;
        }

        protected void tick(ServerLevel level, SealEntity entity, long gameTime) {
            if (entity.layCooldown > 0) {
                --entity.layCooldown;
            }
        }
    }

    public static class LayBehavior
    extends Behavior<SealEntity> {
        public LayBehavior() {
            super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), 1200);
        }

        protected boolean checkExtraStartConditions(ServerLevel level, SealEntity entity) {
            return entity.layCooldown == 0 && entity.canStartLaying();
        }

        protected void start(ServerLevel level, SealEntity entity, long gameTime) {
            entity.startLayingDown();
        }

        protected boolean canStillUse(ServerLevel level, SealEntity entity, long gameTime) {
            return entity.getLayState() != SealEntity.LayState.STANDING;
        }

        protected void tick(ServerLevel level, SealEntity entity, long gameTime) {
            boolean shouldAbort;
            Brain brain = entity.getBrain();
            SealEntity.LayState layState = entity.getLayState();
            boolean bl = shouldAbort = brain.hasMemoryValue(MemoryModuleType.IS_PANICKING) || brain.hasMemoryValue(MemoryModuleType.TEMPTING_PLAYER) || entity.isInWaterOrBubble();
            if ((layState == SealEntity.LayState.LAYING_DOWN || layState == SealEntity.LayState.LAYING) && shouldAbort) {
                entity.startGettingUp();
                layState = entity.getLayState();
            }
            switch (layState) {
                case LAYING_DOWN: {
                    if (--entity.layTime > 0) break;
                    entity.layTime = SealEntity.LAY_DURATION.sample(entity.getRandom());
                    entity.setLayState(SealEntity.LayState.LAYING);
                    break;
                }
                case LAYING: {
                    entity.getNavigation().stop();
                    if (--entity.layTime > 0) break;
                    entity.startGettingUp();
                    break;
                }
                case GETTING_UP: {
                    if (--entity.layTime > 0) break;
                    entity.finishGettingUp();
                    break;
                }
            }
        }

        protected void stop(ServerLevel level, SealEntity entity, long gameTime) {
            if (entity.getLayState() != SealEntity.LayState.STANDING) {
                entity.finishGettingUp();
            }
        }
    }

    public static class SealHuntFish
    extends Behavior<SealEntity> {
        private final float speed;
        private final double maxDistance;
        private final double maxDistanceSqr;
        private LivingEntity targetFish;
        private ItemEntity targetItem;
        private int attackCooldown;

        public SealHuntFish(float speed, double maxDistance) {
            super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT));
            this.speed = speed;
            this.maxDistance = maxDistance;
            this.maxDistanceSqr = maxDistance * maxDistance;
        }

        protected boolean checkExtraStartConditions(ServerLevel level, SealEntity seal) {
            if (seal.hasEnvironmentTarget()) {
                return false;
            }
            if (!seal.isInWaterOrBubble()) {
                return false;
            }
            if (seal.getBrain().hasMemoryValue(MemoryModuleType.IS_PANICKING)) {
                return false;
            }
            this.targetFish = null;
            this.targetItem = null;
            double nearestDist = this.maxDistanceSqr;
            ItemEntity bestItem = null;
            for (ItemEntity item : level.getEntitiesOfClass(ItemEntity.class, seal.getBoundingBox().inflate(this.maxDistance), it -> it.isAlive() && it.isInWaterOrBubble() && it.getItem().is(ReAnimalTags.Items.SEAL_FOOD))) {
                double d = seal.distanceToSqr((Entity)item);
                if (!(d <= nearestDist)) continue;
                nearestDist = d;
                bestItem = item;
            }
            if (bestItem != null) {
                this.targetItem = bestItem;
                this.attackCooldown = 0;
                return true;
            }
            Optional opt = seal.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
            if (opt.isEmpty()) {
                return false;
            }
            NearestVisibleLivingEntities visible = (NearestVisibleLivingEntities)opt.get();
            this.targetFish = visible.findClosest(e -> {
                AbstractFish fish;
                return e instanceof AbstractFish && (fish = (AbstractFish)e).isAlive() && seal.distanceToSqr((Entity)fish) <= this.maxDistanceSqr;
            }).orElse(null);
            if (this.targetFish == null) {
                return false;
            }
            seal.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)this.targetFish);
            this.attackCooldown = 0;
            return true;
        }

        protected boolean canStillUse(ServerLevel level, SealEntity seal, long gameTime) {
            if (seal.hasEnvironmentTarget()) {
                return false;
            }
            if (!seal.isInWaterOrBubble()) {
                return false;
            }
            if (seal.getBrain().hasMemoryValue(MemoryModuleType.IS_PANICKING)) {
                return false;
            }
            if (this.targetItem != null) {
                if (!this.targetItem.isAlive()) {
                    return false;
                }
                return !(seal.distanceToSqr((Entity)this.targetItem) > this.maxDistanceSqr);
            }
            if (this.targetFish != null) {
                if (!this.targetFish.isAlive()) {
                    return false;
                }
                return !(seal.distanceToSqr((Entity)this.targetFish) > this.maxDistanceSqr);
            }
            return false;
        }

        protected void stop(ServerLevel level, SealEntity seal, long gameTime) {
            Brain brain = seal.getBrain();
            if (this.targetFish != null) {
                brain.eraseMemory(MemoryModuleType.ATTACK_TARGET);
            }
            this.targetFish = null;
            this.targetItem = null;
        }

        protected void tick(ServerLevel level, SealEntity seal, long gameTime) {
            double attackReach;
            if (this.targetItem != null) {
                double reach;
                seal.getLookControl().setLookAt((Entity)this.targetItem, 30.0f, 30.0f);
                seal.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(this.targetItem.position(), this.speed, 0));
                if (this.attackCooldown > 0) {
                    --this.attackCooldown;
                    return;
                }
                double distSqr = seal.distanceToSqr((Entity)this.targetItem);
                if (distSqr <= (reach = 1.5) * reach) {
                    seal.doHurtTarget((Entity)this.targetItem);
                    this.attackCooldown = 20;
                }
                return;
            }
            if (this.targetFish == null) {
                return;
            }
            seal.getLookControl().setLookAt((Entity)this.targetFish, 30.0f, 30.0f);
            seal.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((Entity)this.targetFish, this.speed, 0));
            if (this.attackCooldown > 0) {
                --this.attackCooldown;
                return;
            }
            double distSqr = seal.distanceToSqr((Entity)this.targetFish);
            if (distSqr <= (attackReach = 2.0) * attackReach) {
                seal.doHurtTarget((Entity)this.targetFish);
                this.attackCooldown = 20;
            }
        }
    }

    public static class SealMoveToEnvironmentTarget
    extends Behavior<SealEntity> {
        private final float speed;

        public SealMoveToEnvironmentTarget(float speed) {
            super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED));
            this.speed = speed;
        }

        protected boolean checkExtraStartConditions(ServerLevel level, SealEntity seal) {
            return seal.hasEnvironmentTarget() && !seal.isLaying() && !seal.getBrain().hasMemoryValue(MemoryModuleType.IS_PANICKING);
        }

        protected void start(ServerLevel level, SealEntity seal, long gameTime) {
            BlockPos target = seal.getEnvironmentTarget();
            if (target == null) {
                return;
            }
            seal.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(target, this.speed, 0));
        }

        protected boolean canStillUse(ServerLevel level, SealEntity seal, long gameTime) {
            if (!seal.hasEnvironmentTarget()) {
                return false;
            }
            if (seal.isAtEnvironmentTarget()) {
                return false;
            }
            return !seal.getBrain().hasMemoryValue(MemoryModuleType.IS_PANICKING);
        }

        protected void tick(ServerLevel level, SealEntity seal, long gameTime) {
            BlockPos target = seal.getEnvironmentTarget();
            if (target == null) {
                return;
            }
            seal.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(target, this.speed, 0));
            if (seal.isAtEnvironmentTarget()) {
                seal.clearEnvironmentTarget();
            }
        }

        protected void stop(ServerLevel level, SealEntity seal, long gameTime) {
            if (seal.isAtEnvironmentTarget()) {
                seal.clearEnvironmentTarget();
            }
            seal.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        }
    }

    public static class SealSwitchEnvironment
    extends Behavior<SealEntity> {
        private final int radius;
        private final float startChance;
        private long lastSwitchGameTime;

        public SealSwitchEnvironment(int radius, float startChance) {
            super((Map)ImmutableMap.of());
            this.radius = radius;
            this.startChance = startChance;
        }

        protected boolean checkExtraStartConditions(ServerLevel level, SealEntity seal) {
            if (seal.isLaying()) {
                return false;
            }
            long time = level.getGameTime();
            if (time - this.lastSwitchGameTime < 400L) {
                return false;
            }
            return !(seal.getRandom().nextFloat() > this.startChance);
        }

        protected void start(ServerLevel level, SealEntity seal, long gameTime) {
            BlockPos best = this.findTarget(level, seal);
            if (best != null) {
                seal.setEnvironmentTarget(best);
                this.lastSwitchGameTime = gameTime;
            }
        }

        private BlockPos findTarget(ServerLevel level, SealEntity seal) {
            BlockPos origin = seal.blockPosition();
            RandomSource random = seal.getRandom();
            boolean toLand = seal.isInWaterOrBubble();
            for (int i = 0; i < 40; ++i) {
                int z;
                int dx = random.nextInt(this.radius * 2 + 1) - this.radius;
                int dz = random.nextInt(this.radius * 2 + 1) - this.radius;
                int x = origin.getX() + dx;
                int topY = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z = origin.getZ() + dz);
                if (topY <= level.getMinBuildHeight()) continue;
                BlockPos surface = new BlockPos(x, topY - 1, z);
                BlockState surfaceState = level.getBlockState(surface);
                FluidState surfaceFluid = level.getFluidState(surface);
                BlockPos head = surface.above();
                BlockState headState = level.getBlockState(head);
                FluidState headFluid = level.getFluidState(head);
                if (toLand ? surfaceState.isAir() || surfaceFluid.is(FluidTags.WATER) || !headState.isAir() || !headFluid.isEmpty() : !surfaceFluid.is(FluidTags.WATER) || !headState.isAir() && !headFluid.is(FluidTags.WATER)) continue;
                return head.immutable();
            }
            return null;
        }

        protected boolean canStillUse(ServerLevel level, SealEntity seal, long gameTime) {
            return false;
        }
    }

    public static class SealSwim
    extends Behavior<SealEntity> {
        private final float speed;

        public SealSwim(float speed) {
            super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
            this.speed = speed;
        }

        protected boolean checkExtraStartConditions(ServerLevel level, SealEntity seal) {
            if (seal.hasEnvironmentTarget()) {
                return false;
            }
            return seal.isInWaterOrBubble();
        }

        protected void start(ServerLevel level, SealEntity seal, long gameTime) {
            RandomSource random = seal.getRandom();
            for (int i = 0; i < 10; ++i) {
                double dz;
                double dy;
                double dx = seal.getX() + (random.nextDouble() * 2.0 - 1.0) * 6.0;
                BlockPos pos = BlockPos.containing((double)dx, (double)(dy = seal.getY() + (random.nextDouble() * 2.0 - 1.0) * 3.0), (double)(dz = seal.getZ() + (random.nextDouble() * 2.0 - 1.0) * 6.0));
                if (!level.getFluidState(pos).is(FluidTags.WATER)) continue;
                seal.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(pos, this.speed, 0));
                return;
            }
        }

        protected boolean canStillUse(ServerLevel level, SealEntity seal, long gameTime) {
            if (seal.hasEnvironmentTarget()) {
                return false;
            }
            return seal.isInWaterOrBubble();
        }
    }

    public static class SealLandStroll
    extends Behavior<SealEntity> {
        private final float speed;
        private final int minRunTime;
        private final int maxRunTime;
        private final int minIdleTime;
        private final int maxIdleTime;
        private long endTick;
        private long nextStartTick;

        public SealLandStroll(float speed, int minRunTime, int maxRunTime, int minIdleTime, int maxIdleTime) {
            super((Map)ImmutableMap.of());
            this.speed = speed;
            this.minRunTime = minRunTime;
            this.maxRunTime = maxRunTime;
            this.minIdleTime = minIdleTime;
            this.maxIdleTime = maxIdleTime;
        }

        protected boolean checkExtraStartConditions(ServerLevel level, SealEntity seal) {
            if (seal.hasEnvironmentTarget()) {
                return false;
            }
            if (seal.isLaying()) {
                return false;
            }
            if (seal.isSwimming()) {
                return false;
            }
            long gameTime = level.getGameTime();
            if (gameTime < this.nextStartTick) {
                return false;
            }
            Vec3 pos = LandRandomPos.getPos((PathfinderMob)seal, (int)10, (int)7);
            if (pos == null) {
                return false;
            }
            seal.getNavigation().moveTo(pos.x, pos.y, pos.z, (double)this.speed);
            this.endTick = gameTime + (long)Mth.nextInt((RandomSource)seal.getRandom(), (int)this.minRunTime, (int)this.maxRunTime);
            return true;
        }

        protected boolean canStillUse(ServerLevel level, SealEntity seal, long gameTime) {
            if (seal.hasEnvironmentTarget()) {
                return false;
            }
            return !seal.isInWaterOrBubble() && !seal.getNavigation().isDone() && gameTime < this.endTick;
        }

        protected void start(ServerLevel level, SealEntity seal, long gameTime) {
        }

        protected void stop(ServerLevel level, SealEntity seal, long gameTime) {
            seal.getNavigation().stop();
            this.nextStartTick = gameTime + (long)Mth.nextInt((RandomSource)seal.getRandom(), (int)this.minIdleTime, (int)this.maxIdleTime);
        }

        protected void tick(ServerLevel level, SealEntity seal, long gameTime) {
        }
    }
}

