/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.entity.ostrich;

import com.mojang.serialization.Dynamic;
import it.hurts.shatterbyte.reanimal.common.entity.ostrich.OstrichAI;
import it.hurts.shatterbyte.reanimal.init.ReAnimalEntities;
import it.hurts.shatterbyte.reanimal.init.ReAnimalItems;
import it.hurts.shatterbyte.reanimal.init.ReAnimalSoundEvents;
import it.hurts.shatterbyte.reanimal.init.ReAnimalTags;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OstrichEntity
extends Animal
implements GeoEntity,
PlayerRideableJumping {
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.ostrich.idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.ostrich.walk");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("animation.ostrich.run");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.defineId(OstrichEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private float jumpPower;
    private int eggTime = this.random.nextInt(6000) + 6000;

    public boolean isSaddled() {
        return (Boolean)this.entityData.get(SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.entityData.set(SADDLED, (Object)saddled);
    }

    public OstrichEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.getNavigation().setCanFloat(true);
    }

    public void aiStep() {
        super.aiStep();
        this.tickEggLaying();
        if (!this.level().isClientSide() && this.isVehicle() && this.isInWater()) {
            this.ejectPassengers();
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.isBaby()) {
            return super.mobInteract(player, hand);
        }
        ItemStack stack = player.getItemInHand(hand);
        Level level = this.level();
        if (stack.is(Items.SADDLE) && !this.isSaddled()) {
            if (!level.isClientSide()) {
                this.setSaddled(true);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                level.playSound(null, (Entity)this, SoundEvents.HORSE_SADDLE, this.getSoundSource(), 1.0f, 1.0f);
                this.gameEvent((Holder)GameEvent.EQUIP);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (this.isSaddled() && !this.isVehicle()) {
            if (!level.isClientSide()) {
                player.startRiding((Entity)this);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.mobInteract(player, hand);
    }

    public void travel(Vec3 travelVector) {
        LivingEntity rider = this.getControllingPassenger();
        if (rider != null && this.isSaddled() && this.isVehicle()) {
            this.setYRot(rider.getYRot());
            this.yRotO = this.getYRot();
            this.setXRot(rider.getXRot() * 0.5f);
            this.setRot(this.getYRot(), this.getXRot());
            this.yBodyRot = this.getYRot();
            this.yHeadRot = this.getYRot();
            float strafe = rider.xxa * 0.5f;
            float forward = rider.zza;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) * 1.5f);
            super.travel(new Vec3((double)strafe, travelVector.y, (double)forward));
        } else {
            super.travel(travelVector);
        }
    }

    protected void customServerAiStep() {
        Level level = this.level();
        ProfilerFiller profiler = level.getProfiler();
        profiler.push("ostrichBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        profiler.pop();
        profiler.push("ostrichActivityUpdate");
        OstrichAI.updateActivity(this);
        profiler.pop();
        this.setSprinting(this.isPanicking());
        super.customServerAiStep();
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean result = super.hurt(source, amount);
        if (result) {
            this.getBrain().setMemory(MemoryModuleType.IS_PANICKING, (Object)true);
            OstrichAI.updateActivity(this);
        }
        return result;
    }

    public void onPlayerJump(int power) {
        this.jumpPower = Math.min(1.0f, (float)power / 100.0f);
        if (!(this.isSaddled() && this.isVehicle() && this.onGround())) {
            return;
        }
        if (this.jumpPower <= 0.0f) {
            return;
        }
        double jumpY = 0.5 * (double)this.jumpPower;
        Vec3 motion = this.getDeltaMovement();
        Vec3 look = this.getLookAngle();
        double forwardBoost = 2.0 * (double)this.jumpPower;
        this.setDeltaMovement(motion.x + look.x * forwardBoost, jumpY, motion.z + look.z * forwardBoost);
        this.hasImpulse = true;
    }

    public boolean canJump() {
        return this.isSaddled() && this.isVehicle();
    }

    public void handleStartJump(int power) {
        this.jumpPower = 0.0f;
    }

    public void handleStopJump() {
    }

    public LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living;
        }
        return null;
    }

    public void die(DamageSource source) {
        super.die(source);
        this.ejectPassengers();
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource source, boolean recentlyHit) {
        super.dropCustomDeathLoot(level, source, recentlyHit);
        if (this.isSaddled()) {
            this.spawnAtLocation((ItemLike)Items.SADDLE);
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("saddled", this.isSaddled());
        tag.putInt("eggTime", this.eggTime);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSaddled(tag.getBoolean("saddled"));
        this.eggTime = tag.contains("eggTime") ? tag.getInt("eggTime") : this.random.nextInt(6000) + 6000;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return super.getPassengerRidingPosition(entity).add(0.0, -1.0, 0.0);
    }

    protected Brain.Provider<OstrichEntity> brainProvider() {
        return OstrichAI.brainProvider();
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return OstrichAI.makeBrain((Brain<OstrichEntity>)this.brainProvider().makeBrain(dynamic));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SADDLED, (Object)false);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ReAnimalTags.Items.OSTRICH_FOOD);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ReAnimalSoundEvents.OSTRICH_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ReAnimalSoundEvents.OSTRICH_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ReAnimalSoundEvents.OSTRICH_DEATH.get();
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob partner) {
        OstrichEntity baby = (OstrichEntity)((EntityType)ReAnimalEntities.OSTRICH.get()).create((Level)level);
        if (baby != null) {
            baby.setBaby(true);
        }
        return baby;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "main", 5, this::mainPredicate));
    }

    private PlayState mainPredicate(AnimationState<OstrichEntity> state) {
        AnimationController controller = state.getController();
        OstrichEntity entity = (OstrichEntity)state.getAnimatable();
        if (state.isMoving()) {
            if (entity.isSprinting() || entity.isVehicle()) {
                controller.setAnimation(RUN);
            } else {
                controller.setAnimation(WALK);
            }
        } else {
            controller.setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    private void tickEggLaying() {
        if (this.level().isClientSide() || this.isBaby()) {
            return;
        }
        if (--this.eggTime > 0) {
            return;
        }
        this.playSound(SoundEvents.CHICKEN_EGG, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        this.spawnAtLocation((ItemLike)ReAnimalItems.OSTRICH_EGG.get());
        this.gameEvent((Holder)GameEvent.ENTITY_PLACE, (Entity)this);
        this.eggTime = this.random.nextInt(6000) + 6000;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.35).add(Attributes.STEP_HEIGHT, 1.1).add(Attributes.SAFE_FALL_DISTANCE, 8.0);
    }
}

