/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.entity.hippopotamus;

import com.mojang.serialization.Dynamic;
import it.hurts.shatterbyte.reanimal.common.entity.hippopotamus.HippopotamusAI;
import it.hurts.shatterbyte.reanimal.init.ReAnimalEntities;
import it.hurts.shatterbyte.reanimal.init.ReAnimalSoundEvents;
import it.hurts.shatterbyte.reanimal.init.ReAnimalTags;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HippopotamusEntity
extends Animal
implements GeoEntity {
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.hippopotamus.idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.hippopotamus.walk");
    private static final RawAnimation LAYING = RawAnimation.begin().then("animation.hippopotamus.laying", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation IDLE_LAY = RawAnimation.begin().thenLoop("animation.hippopotamus.idle_lay");
    private static final RawAnimation GETTING_UP = RawAnimation.begin().then("animation.hippopotamus.getting_up", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation ATTACK_1 = RawAnimation.begin().then("animation.hippopotamus.attack_1", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation ATTACK_2 = RawAnimation.begin().then("animation.hippopotamus.attack_2", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation[] ATTACKS = new RawAnimation[]{ATTACK_1, ATTACK_2};
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.defineId(HippopotamusEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> LAY_STATE = SynchedEntityData.defineId(HippopotamusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int LAY_TRANSITION_TICKS = 15;
    public static final UniformInt LAY_DURATION = UniformInt.of((int)200, (int)400);
    private static final UniformInt LAY_COOLDOWN = UniformInt.of((int)200, (int)400);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int attackAnimationTicks;
    public int layTime;
    public int layCooldown;

    public HippopotamusEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.getNavigation().setCanFloat(true);
    }

    public boolean isAttacking() {
        return (Boolean)this.entityData.get(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.entityData.set(ATTACKING, (Object)attacking);
    }

    public boolean isLaying() {
        LayState state = this.getLayState();
        return state == LayState.LAYING_DOWN || state == LayState.LAYING || state == LayState.GETTING_UP;
    }

    public LayState getLayState() {
        return LayState.byId((Integer)this.entityData.get(LAY_STATE));
    }

    public void setLayState(LayState state) {
        this.entityData.set(LAY_STATE, (Object)state.ordinal());
    }

    public void startAttackAnimation() {
        this.attackAnimationTicks = 12;
        this.setAttacking(true);
    }

    protected void customServerAiStep() {
        Brain brain = this.getBrain();
        LivingEntity lastAttacker = this.getLastHurtByMob();
        if (lastAttacker != null && HippopotamusAI.isValidTarget(this, lastAttacker)) {
            brain.setMemory(MemoryModuleType.ATTACK_TARGET, (Object)lastAttacker);
        }
        brain.getMemory(MemoryModuleType.ATTACK_TARGET).ifPresent(target -> {
            if (!HippopotamusAI.isValidTarget(this, target) || HippopotamusAI.isHoldingFavoriteFood(target)) {
                brain.eraseMemory(MemoryModuleType.ATTACK_TARGET);
                brain.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
            }
        });
        Level level = this.level();
        ProfilerFiller profiler = level.getProfiler();
        profiler.push("hippopotamusBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        profiler.pop();
        profiler.push("hippopotamusActivityUpdate");
        HippopotamusAI.updateActivity(this);
        profiler.pop();
        super.customServerAiStep();
    }

    public void aiStep() {
        super.aiStep();
        if (this.isLaying()) {
            this.setXRot(0.0f);
            this.xRotO = 0.0f;
            this.yHeadRot = this.yBodyRot;
            this.yHeadRotO = this.yBodyRotO;
        }
        if (!this.isBaby() && (this.brain.hasMemoryValue(MemoryModuleType.TEMPTING_PLAYER) || this.brain.hasMemoryValue(MemoryModuleType.IS_TEMPTED))) {
            this.brain.eraseMemory(MemoryModuleType.TEMPTING_PLAYER);
            this.brain.eraseMemory(MemoryModuleType.IS_TEMPTED);
        }
        if (!this.level().isClientSide && this.attackAnimationTicks > 0) {
            --this.attackAnimationTicks;
            if (this.attackAnimationTicks == 0 && this.isAttacking()) {
                this.setAttacking(false);
            }
        }
        if (!this.level().isClientSide && this.isLaying()) {
            this.getNavigation().stop();
        }
    }

    protected Brain.Provider<HippopotamusEntity> brainProvider() {
        return HippopotamusAI.brainProvider();
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return HippopotamusAI.makeBrain((Brain<HippopotamusEntity>)this.brainProvider().makeBrain(dynamic));
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ReAnimalTags.Items.HIPPOPOTAMUS_FOOD);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ReAnimalSoundEvents.HIPPOPOTAMUS_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ReAnimalSoundEvents.HIPPOPOTAMUS_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ReAnimalSoundEvents.HIPPOPOTAMUS_DEATH.get();
    }

    public boolean isInvulnerableTo(DamageSource source) {
        Entity direct = source.getDirectEntity();
        if (direct instanceof AbstractArrow && source.is(DamageTypeTags.IS_PROJECTILE)) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    protected void defineSynchedData(SynchedEntityData.Builder buidler) {
        super.defineSynchedData(buidler);
        buidler.define(ATTACKING, (Object)false);
        buidler.define(LAY_STATE, (Object)LayState.STANDING.ordinal());
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob partner) {
        HippopotamusEntity baby = (HippopotamusEntity)((EntityType)ReAnimalEntities.HIPPOPOTAMUS.get()).create((Level)level);
        if (baby != null) {
            baby.setBaby(true);
        }
        return baby;
    }

    public boolean doHurtTarget(Entity target) {
        return super.doHurtTarget(target);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "main", 5, this::mainPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attack", 5, this::attackPredicate));
    }

    private PlayState mainPredicate(AnimationState<HippopotamusEntity> state) {
        AnimationController controller = state.getController();
        switch (this.getLayState().ordinal()) {
            case 1: {
                controller.setAnimation(LAYING);
                break;
            }
            case 2: {
                controller.setAnimation(IDLE_LAY);
                break;
            }
            case 3: {
                controller.setAnimation(GETTING_UP);
                break;
            }
            case 0: {
                if (state.isMoving()) {
                    controller.setAnimation(WALK);
                    break;
                }
                controller.setAnimation(IDLE);
            }
        }
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState<HippopotamusEntity> state) {
        AnimationController controller = state.getController();
        if (this.isAttacking()) {
            this.setAttacking(false);
            controller.forceAnimationReset();
            controller.setAnimation((RawAnimation)Util.getRandom((Object[])ATTACKS, (RandomSource)this.getRandom()));
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 60.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.85).add(Attributes.STEP_HEIGHT, 1.1);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("LayState", ((Integer)this.entityData.get(LAY_STATE)).intValue());
        tag.putInt("LayTime", this.layTime);
        tag.putInt("LayCooldown", this.layCooldown);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("LayState")) {
            this.setLayState(LayState.byId(tag.getInt("LayState")));
        }
        if (tag.contains("LayTime")) {
            this.layTime = tag.getInt("LayTime");
        }
        if (tag.contains("LayCooldown")) {
            this.layCooldown = tag.getInt("LayCooldown");
        }
    }

    protected BodyRotationControl createBodyControl() {
        return new BodyRotationControl((Mob)this){

            public void clientTick() {
                if (HippopotamusEntity.this.isLaying()) {
                    return;
                }
                super.clientTick();
            }
        };
    }

    public boolean canStartLaying() {
        return !this.isVehicle() && !this.isInWaterOrBubble() && !this.getNavigation().isInProgress() && this.getDeltaMovement().horizontalDistanceSqr() < 1.0E-4 && !this.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET) && !this.getBrain().hasMemoryValue(MemoryModuleType.IS_PANICKING) && !this.getBrain().hasMemoryValue(MemoryModuleType.TEMPTING_PLAYER) && this.random.nextInt(600) == 0;
    }

    public void startLayingDown() {
        this.getNavigation().stop();
        this.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        this.setLayState(LayState.LAYING_DOWN);
        this.layTime = 15;
    }

    public void startGettingUp() {
        this.setLayState(LayState.GETTING_UP);
        this.layTime = 15;
    }

    public void finishGettingUp() {
        this.setLayState(LayState.STANDING);
        this.layCooldown = LAY_COOLDOWN.sample(this.random);
    }

    public static enum LayState {
        STANDING,
        LAYING_DOWN,
        LAYING,
        GETTING_UP;


        public static LayState byId(int id) {
            LayState[] values = LayState.values();
            return id >= 0 && id < values.length ? values[id] : STANDING;
        }
    }
}

