/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.entity.glow_stick;

import it.hurts.octostudios.octolib.module.particle.trail.EntityTrailProvider;
import it.hurts.shatterbyte.reanimal.common.block.GlowLightBlock;
import it.hurts.shatterbyte.reanimal.common.blockentity.GlowLightBlockEntity;
import it.hurts.shatterbyte.reanimal.init.ReAnimalBlocks;
import it.hurts.shatterbyte.reanimal.init.ReAnimalItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GlowStickEntity
extends ThrowableItemProjectile
implements GeoEntity {
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.glow_stick.idle");
    private static final double BOUNCE_DAMPING = 0.7;
    private static final double BOUNCE_Y_CUTOFF = 0.18;
    private static final double STOP_SPEED_SQR = 0.03;
    private static final int MAX_LIFETIME = 6000;
    private static final EntityDataAccessor<Float> RENDER_YAW = SynchedEntityData.defineId(GlowStickEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> RENDER_PITCH = SynchedEntityData.defineId(GlowStickEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> RENDER_ROLL = SynchedEntityData.defineId(GlowStickEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private float renderYaw;
    private float renderYawO;
    private float renderPitch;
    private float renderPitchO;
    private Vec3 renderMotion = Vec3.ZERO;
    private Vec3 renderMotionO = Vec3.ZERO;
    private float renderRoll;
    private float renderRollO;
    private float rollSpeed;

    public GlowStickEntity(EntityType<? extends GlowStickEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(RENDER_YAW, (Object)Float.valueOf(0.0f));
        builder.define(RENDER_PITCH, (Object)Float.valueOf(0.0f));
        builder.define(RENDER_ROLL, (Object)Float.valueOf(0.0f));
    }

    protected Item getDefaultItem() {
        return (Item)ReAnimalItems.GLOW_STICK_WHITE.get();
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        result.getEntity().hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
    }

    protected void onHitBlock(BlockHitResult result) {
        Vec3 hitLocation;
        BlockHitResult hit;
        Vec3 motion = this.getDeltaMovement();
        Vec3 hitPos = result.getLocation();
        Vec3 normal = Vec3.atLowerCornerOf((Vec3i)result.getDirection().getNormal());
        Vec3 bounce = motion.subtract(normal.scale(2.0 * motion.dot(normal))).scale(0.7);
        if (result.getDirection().getAxis() == Direction.Axis.Y && Math.abs(bounce.y) < 0.18) {
            bounce = new Vec3(bounce.x, 0.0, bounce.z);
        }
        Vec3 pos = new Vec3(hitPos.x + normal.x * 0.01, hitPos.y + normal.y * 0.01, hitPos.z + normal.z * 0.01);
        for (int i = 0; i < 2 && bounce.lengthSqr() > 1.0E-8 && (hit = this.level().clip(new ClipContext(pos, pos.add(bounce), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this))).getType() == HitResult.Type.BLOCK && !((hitLocation = hit.getLocation()).distanceToSqr(pos) < 1.0E-10); ++i) {
            Vec3 hitNormal = Vec3.atLowerCornerOf((Vec3i)hit.getDirection().getNormal());
            bounce = bounce.subtract(hitNormal.scale(2.0 * bounce.dot(hitNormal))).scale(0.7);
            if (hit.getDirection().getAxis() == Direction.Axis.Y && Math.abs(bounce.y) < 0.18) {
                bounce = new Vec3(bounce.x, 0.0, bounce.z);
            }
            pos = new Vec3(hitLocation.x + hitNormal.x * 0.01, hitLocation.y + hitNormal.y * 0.01, hitLocation.z + hitNormal.z * 0.01);
        }
        this.setPos(pos.x, pos.y, pos.z);
        this.setDeltaMovement(bounce);
        this.hasImpulse = true;
    }

    public void tick() {
        double speedSqr;
        super.tick();
        if (this.tickCount > 20) {
            for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox())) {
                this.setDeltaMovement(this.position().subtract(entity.position()).normalize().multiply((double)0.35f, 0.0, (double)0.35f).add(0.0, (double)0.2f, 0.0));
            }
        }
        this.renderYawO = this.renderYaw;
        this.renderPitchO = this.renderPitch;
        this.renderMotionO = this.renderMotion;
        this.renderRollO = this.renderRoll;
        Vec3 motion = this.getDeltaMovement();
        if (this.tickCount > 1) {
            GlowStickEntity.tryPlaceGlowLight(this.level(), BlockPos.containing((Position)this.position()));
        }
        double lerp = (speedSqr = motion.lengthSqr()) > 0.0025 ? 0.25 : 0.12;
        Vec3 targetMotion = speedSqr > 9.0E-4 ? motion : Vec3.ZERO;
        this.renderMotion = new Vec3(Mth.lerp((double)lerp, (double)this.renderMotion.x, (double)targetMotion.x), Mth.lerp((double)lerp, (double)this.renderMotion.y, (double)targetMotion.y), Mth.lerp((double)lerp, (double)this.renderMotion.z, (double)targetMotion.z));
        double horSqr = this.renderMotion.x * this.renderMotion.x + this.renderMotion.z * this.renderMotion.z;
        if (horSqr > 1.0E-4) {
            Vec3 dir = new Vec3(this.renderMotion.x, 0.0, this.renderMotion.z).normalize();
            float targetYaw = (float)(Mth.atan2((double)dir.x, (double)dir.z) * 57.2957763671875);
            this.renderYaw = Mth.rotLerp((float)0.18f, (float)this.renderYaw, (float)targetYaw);
            this.renderPitch = Mth.lerp((float)0.12f, (float)this.renderPitch, (float)0.0f);
        }
        float speed = (float)this.renderMotion.length();
        float speedFactor = Mth.clamp((float)(speed / 0.2f), (float)0.0f, (float)1.0f);
        speedFactor *= speedFactor;
        float targetSpin = Mth.clamp((float)(speed * 140.0f), (float)(speed > 0.02f ? 3.0f : 0.0f), (float)36.0f);
        this.rollSpeed = Mth.lerp((float)0.2f, (float)this.rollSpeed, (float)targetSpin);
        this.rollSpeed *= this.onGround() ? 0.95f : 0.99f;
        this.renderRoll += this.rollSpeed * speedFactor;
        if (!this.level().isClientSide() && this.tickCount > 6000) {
            this.expireToItem();
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("renderYaw", this.renderYaw);
        tag.putFloat("renderPitch", this.renderPitch);
        tag.putFloat("renderRoll", this.renderRoll);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("renderYaw")) {
            float yaw;
            this.renderYaw = yaw = tag.getFloat("renderYaw");
            this.getEntityData().set(RENDER_YAW, (Object)Float.valueOf(yaw));
        }
        if (tag.contains("renderPitch")) {
            float pitch;
            this.renderPitch = pitch = tag.getFloat("renderPitch");
            this.getEntityData().set(RENDER_PITCH, (Object)Float.valueOf(pitch));
        }
        if (tag.contains("renderRoll")) {
            float roll;
            this.renderRoll = roll = tag.getFloat("renderRoll");
            this.getEntityData().set(RENDER_ROLL, (Object)Float.valueOf(roll));
        }
        this.renderYawO = this.renderYaw;
        this.renderPitchO = this.renderPitch;
        this.renderRollO = this.renderRoll;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key == RENDER_YAW) {
            this.renderYawO = this.renderYaw = ((Float)this.getEntityData().get(RENDER_YAW)).floatValue();
        } else if (key == RENDER_PITCH) {
            this.renderPitchO = this.renderPitch = ((Float)this.getEntityData().get(RENDER_PITCH)).floatValue();
        } else if (key == RENDER_ROLL) {
            this.renderRollO = this.renderRoll = ((Float)this.getEntityData().get(RENDER_ROLL)).floatValue();
        }
    }

    public static void tryPlaceGlowLight(Level level, BlockPos basePos) {
        if (level.isClientSide()) {
            return;
        }
        BlockPos pos = GlowStickEntity.findLightPos(level, basePos);
        if (pos == null) {
            return;
        }
        FluidState fluidState = level.getFluidState(pos);
        BlockState glowState = (BlockState)((GlowLightBlock)((Object)ReAnimalBlocks.GLOW_LIGHT.get())).defaultBlockState().setValue((Property)GlowLightBlock.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.is(FluidTags.WATER)));
        level.setBlock(pos, glowState, 3);
    }

    private static BlockPos findLightPos(Level level, BlockPos base) {
        BlockPos[] candidates;
        for (BlockPos pos : candidates = new BlockPos[]{base, base.above(), base.below(), base.north(), base.south(), base.east(), base.west()}) {
            BlockState state = level.getBlockState(pos);
            if (!state.is((Block)ReAnimalBlocks.GLOW_LIGHT.get())) continue;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof GlowLightBlockEntity) {
                GlowLightBlockEntity glowLight = (GlowLightBlockEntity)blockEntity;
                glowLight.refresh();
            }
            return null;
        }
        for (BlockPos pos : candidates) {
            if (!GlowStickEntity.canPlaceLightAt(level, pos)) continue;
            return pos;
        }
        return null;
    }

    private static boolean canPlaceLightAt(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.is((Block)ReAnimalBlocks.GLOW_LIGHT.get())) {
            return true;
        }
        if (state.isAir()) {
            return true;
        }
        return state.is(Blocks.WATER);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.tickCount > 20 && player.getInventory().add(this.getItem().copy())) {
            this.discard();
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public boolean isPickable() {
        return true;
    }

    private void expireToItem() {
        if (!this.level().isClientSide()) {
            this.spawnAtLocation(this.getItem().copy());
        }
        this.discard();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "main", 0, this::mainPredicate));
    }

    private PlayState mainPredicate(AnimationState<GlowStickEntity> state) {
        state.getController().setAnimation(IDLE);
        return PlayState.CONTINUE;
    }

    public float getRenderYaw(float partialTick) {
        return Mth.rotLerp((float)partialTick, (float)this.renderYawO, (float)this.renderYaw);
    }

    public float getRenderPitch(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.renderPitchO, (float)this.renderPitch);
    }

    public Vec3 getRenderMotion(float partialTick) {
        return new Vec3(Mth.lerp((double)partialTick, (double)this.renderMotionO.x, (double)this.renderMotion.x), Mth.lerp((double)partialTick, (double)this.renderMotionO.y, (double)this.renderMotion.y), Mth.lerp((double)partialTick, (double)this.renderMotionO.z, (double)this.renderMotion.z));
    }

    public float getRenderRoll(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.renderRollO, (float)this.renderRoll);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TrailProvider
    extends EntityTrailProvider<GlowStickEntity> {
        private static int toColorWithAlpha(int alpha, int rgb) {
            return alpha << 24 | rgb & 0xFFFFFF;
        }

        private static int getBaseColor(Item item) {
            return TrailProvider.getGlowStickBaseColor(item);
        }

        private static int getGlowStickBaseColor(Item item) {
            if (item == ReAnimalItems.GLOW_STICK_WHITE.get()) {
                return 0xFFFFFF;
            }
            if (item == ReAnimalItems.GLOW_STICK_ORANGE.get()) {
                return 16753920;
            }
            if (item == ReAnimalItems.GLOW_STICK_MAGENTA.get()) {
                return 0xFF00FF;
            }
            if (item == ReAnimalItems.GLOW_STICK_LIGHT_BLUE.get()) {
                return 0x55FFFF;
            }
            if (item == ReAnimalItems.GLOW_STICK_YELLOW.get()) {
                return 0xFFFF55;
            }
            if (item == ReAnimalItems.GLOW_STICK_LIME.get()) {
                return 0x55FF55;
            }
            if (item == ReAnimalItems.GLOW_STICK_PINK.get()) {
                return 0xFF55FF;
            }
            if (item == ReAnimalItems.GLOW_STICK_GRAY.get()) {
                return 0x555555;
            }
            if (item == ReAnimalItems.GLOW_STICK_LIGHT_GRAY.get()) {
                return 0xAAAAAA;
            }
            if (item == ReAnimalItems.GLOW_STICK_CYAN.get()) {
                return 43690;
            }
            if (item == ReAnimalItems.GLOW_STICK_PURPLE.get()) {
                return 0xAA00AA;
            }
            if (item == ReAnimalItems.GLOW_STICK_BLUE.get()) {
                return 0x5555FF;
            }
            if (item == ReAnimalItems.GLOW_STICK_BROWN.get()) {
                return 0xAA5500;
            }
            if (item == ReAnimalItems.GLOW_STICK_GREEN.get()) {
                return 43520;
            }
            if (item == ReAnimalItems.GLOW_STICK_RED.get()) {
                return 0xFF0000;
            }
            if (item == ReAnimalItems.GLOW_STICK_BLACK.get()) {
                return 0;
            }
            return 0xFFFFFF;
        }

        private static int getTailColor(Item item) {
            if (item == ReAnimalItems.GLOW_STICK_WHITE.get()) {
                return 6742271;
            }
            if (item == ReAnimalItems.GLOW_STICK_ORANGE.get()) {
                return 16739114;
            }
            if (item == ReAnimalItems.GLOW_STICK_MAGENTA.get()) {
                return 16744376;
            }
            if (item == ReAnimalItems.GLOW_STICK_LIGHT_BLUE.get()) {
                return 6750153;
            }
            if (item == ReAnimalItems.GLOW_STICK_YELLOW.get()) {
                return 16751150;
            }
            if (item == ReAnimalItems.GLOW_STICK_LIME.get()) {
                return 5635962;
            }
            if (item == ReAnimalItems.GLOW_STICK_PINK.get()) {
                return 16737971;
            }
            if (item == ReAnimalItems.GLOW_STICK_GRAY.get()) {
                return 0xDADADA;
            }
            if (item == ReAnimalItems.GLOW_STICK_LIGHT_GRAY.get()) {
                return 0xFFFFFF;
            }
            if (item == ReAnimalItems.GLOW_STICK_CYAN.get()) {
                return 6742271;
            }
            if (item == ReAnimalItems.GLOW_STICK_PURPLE.get()) {
                return 0xFF66D6;
            }
            if (item == ReAnimalItems.GLOW_STICK_BLUE.get()) {
                return 0x66FFE6;
            }
            if (item == ReAnimalItems.GLOW_STICK_BROWN.get()) {
                return 16751150;
            }
            if (item == ReAnimalItems.GLOW_STICK_GREEN.get()) {
                return 8191818;
            }
            if (item == ReAnimalItems.GLOW_STICK_RED.get()) {
                return 16751150;
            }
            if (item == ReAnimalItems.GLOW_STICK_BLACK.get()) {
                return 5974672;
            }
            return 6742271;
        }

        private int getFadeInColorForItem() {
            Item item = ((GlowStickEntity)this.entity).getItem().getItem();
            return TrailProvider.toColorWithAlpha(255, TrailProvider.getBaseColor(item));
        }

        private int getFadeOutColorForItem() {
            Item item = ((GlowStickEntity)this.entity).getItem().getItem();
            return TrailProvider.toColorWithAlpha(128, TrailProvider.getTailColor(item));
        }

        public TrailProvider(GlowStickEntity entity) {
            super((Entity)entity);
        }

        public Vec3 getTrailPosition(float partialTicks) {
            return ((GlowStickEntity)this.entity).getPosition(partialTicks).add(0.0, (double)0.35f, 0.0);
        }

        public int getTrailUpdateFrequency() {
            return 1;
        }

        public boolean isTrailAlive() {
            return ((GlowStickEntity)this.entity).isAlive();
        }

        public boolean isTrailGrowing() {
            return ((GlowStickEntity)this.entity).tickCount > 1;
        }

        public int getTrailMaxLength() {
            return 5;
        }

        public int getTrailFadeInColor() {
            return this.getFadeInColorForItem();
        }

        public int getTrailFadeOutColor() {
            return this.getFadeOutColorForItem();
        }

        public double getTrailScale() {
            return 0.1f;
        }
    }
}

